/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.maven;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintWriter;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;
import org.mule.extension.maven.documentation.DocumentationGenerator;
import org.mule.extension.maven.loader.MavenProjectExtensionModelLoader;
import org.mule.extension.maven.loader.MulePluginJsonDescriberLoader;
import org.mule.plugin.maven.AbstractMuleMojo;
import org.mule.runtime.api.deployment.meta.MulePluginModel;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.zeroturnaround.zip.ZipUtil;

@Mojo(name="documentation", defaultPhase=LifecyclePhase.VERIFY, requiresDependencyResolution=ResolutionScope.TEST, threadSafe=true)
public class ExtensionDocumentationMojo
extends AbstractMuleMojo {
    private static final String DOC_SUFFIX = "-documentation";
    private static final String ZIP = "zip";
    @Parameter(defaultValue="${project}", required=true)
    private MavenProject project;
    @Parameter(defaultValue="${project.build.directory}/temporal-docs", required=true)
    private File outputDir;
    @Component
    private MavenProjectHelper projectHelper;
    private static final DocumentationGenerator documentationGenerator = new DocumentationGenerator();

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (!Boolean.parseBoolean(System.getProperty("mule.maven.extension.model.disable", "false"))) {
            if (!this.outputDir.exists()) {
                this.outputDir.mkdirs();
            }
            MulePluginModel mulePluginModel = MulePluginJsonDescriberLoader.loadMulePluginDescriber(this.outputDirectory);
            MavenProjectExtensionModelLoader extensionModelLoader = new MavenProjectExtensionModelLoader(this.getLog());
            ExtensionModel extension = extensionModelLoader.loadExtension(this.project, mulePluginModel);
            String asciidoc = documentationGenerator.generateAsciidoc(extension);
            String html = documentationGenerator.generateHtml(asciidoc);
            this.generateFile(this.getSanitizedName(extension) + DOC_SUFFIX + ".adoc", asciidoc);
            this.generateFile(this.getSanitizedName(extension) + DOC_SUFFIX + ".html", html);
            File zip = this.createDocsZipArtifact();
            this.projectHelper.attachArtifact(this.project, ZIP, "extension-documentation", zip);
        }
    }

    private File createDocsZipArtifact() {
        File packagedZipFile = new File(this.outputDir.toString() + "." + ZIP);
        ZipUtil.pack((File)this.outputDir, (File)packagedZipFile);
        return packagedZipFile;
    }

    private String getSanitizedName(ExtensionModel extensionModel) {
        return extensionModel.getName().toLowerCase().replace(" ", "-");
    }

    private void generateFile(String fileName, String content) throws MojoExecutionException {
        File file = new File(this.outputDir, fileName);
        try {
            PrintWriter printWriter = new PrintWriter(file);
            printWriter.print(content);
            printWriter.close();
        }
        catch (FileNotFoundException e) {
            throw new MojoExecutionException(String.format("Cannot write the file [%s] (it does not exist), cannot generate documentation", file.getAbsolutePath()), (Exception)e);
        }
        this.getLog().info((CharSequence)String.format("Generated file [%s]", file.getAbsolutePath()));
    }
}

