/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.maven;

import java.io.File;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.FileFileFilter;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.TrueFileFilter;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.mule.plugin.maven.AbstractMuleMojo;
import org.mule.runtime.api.deployment.meta.AbstractMuleArtifactModel;
import org.mule.runtime.api.deployment.meta.MuleArtifactLoaderDescriptor;
import org.mule.runtime.api.deployment.meta.MulePluginModel;
import org.mule.runtime.api.deployment.persistence.MulePluginModelJsonSerializer;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

@Mojo(name="extension-descriptor", defaultPhase=LifecyclePhase.COMPILE, threadSafe=true)
public class ExtensionDescriptorMojo
extends AbstractMuleMojo {
    private static final String META_INF = "META-INF";
    private static final String TEMPORARY_MULE_PLUGIN_JSON = "temporal-mule-plugin.json";
    private static final String MAVEN_ID = "maven";
    private static final String XML_BASED_EXTENSION_MODEL_LOADER = "xml-based";
    private static final String RESOURCE_XML = "resource-xml";
    private static final String PREFIX_SMART_CONNECTOR_NAME = "module-";
    private static final String SUFFIX_SMART_CONNECTOR_NAME = ".xml";
    private static final String MODULE_ROOT_ELEMENT = "module";
    private static final String NAME_ATTRIBUTE = "name";
    private static final String MIN_MULE_VERSION_ATTRIBUTE = "minMuleVersion";

    public static Path descriptorPathOrFail(File outputDirectory) throws MojoFailureException {
        Path path = Paths.get(outputDirectory.getAbsolutePath(), TEMPORARY_MULE_PLUGIN_JSON);
        if (Files.notExists(path, new LinkOption[0])) {
            throw new MojoFailureException(String.format("Should not have reach this point, could not obtain descriptor file from [%s]", path));
        }
        return path;
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        Path originalDescriptorPath = Paths.get(this.project.getBuild().getOutputDirectory(), META_INF, "mule-plugin.json");
        Path descriptorPath = Paths.get(this.outputDirectory.getAbsolutePath(), TEMPORARY_MULE_PLUGIN_JSON);
        if (Files.exists(originalDescriptorPath, new LinkOption[0])) {
            if (descriptorPath.toFile().exists()) {
                FileUtils.deleteQuietly((File)descriptorPath.toFile());
            }
            try {
                Files.copy(originalDescriptorPath, descriptorPath, new CopyOption[0]);
            }
            catch (IOException e) {
                throw new MojoExecutionException(String.format("There was an issue copying the descriptor file from [%s] to [%s]", originalDescriptorPath, descriptorPath), (Exception)e);
            }
        } else {
            this.getLog().info((CharSequence)String.format("No [%s] descriptor found, trying to create one", originalDescriptorPath));
            this.createDescriptor(descriptorPath);
        }
    }

    private void createDescriptor(Path descriptorPath) throws MojoExecutionException {
        String baseDirectory = this.project.getBuild().getOutputDirectory();
        File moduleFile = this.getModuleFile(baseDirectory);
        this.getLog().info((CharSequence)String.format("Generating [%s] descriptor for the <module> found in [%s]", "mule-plugin.json", moduleFile.getAbsolutePath()));
        Document doc = this.getModule(moduleFile).get();
        String name = doc.getDocumentElement().getAttribute(NAME_ATTRIBUTE);
        if (StringUtils.isBlank((CharSequence)name)) {
            throw new MojoExecutionException(String.format("There was an issue storing the dynamically generated descriptor file to [%s]", descriptorPath));
        }
        String minMuleVersion = doc.getDocumentElement().getAttribute(MIN_MULE_VERSION_ATTRIBUTE);
        if (StringUtils.isBlank((CharSequence)minMuleVersion)) {
            throw new MojoExecutionException(String.format("The module being read [%s] must have a non-empty minMuleVersion attribute", moduleFile));
        }
        MulePluginModel.MulePluginModelBuilder mulePluginModelBuilder = (MulePluginModel.MulePluginModelBuilder)((MulePluginModel.MulePluginModelBuilder)new MulePluginModel.MulePluginModelBuilder().setName(name)).setMinMuleVersion(minMuleVersion);
        mulePluginModelBuilder.withBundleDescriptorLoader(new MuleArtifactLoaderDescriptor(MAVEN_ID, new HashMap()));
        mulePluginModelBuilder.withClassLoaderModelDescriber().setId(MAVEN_ID);
        String relativeModuleFileName = moduleFile.getAbsolutePath().substring(baseDirectory.length() + 1, moduleFile.getAbsolutePath().length());
        mulePluginModelBuilder.withExtensionModelDescriber().setId(XML_BASED_EXTENSION_MODEL_LOADER).addProperty(RESOURCE_XML, (Object)relativeModuleFileName);
        MulePluginModel build = mulePluginModelBuilder.build();
        String descriptor = new MulePluginModelJsonSerializer().serialize((AbstractMuleArtifactModel)build);
        try {
            Files.write(descriptorPath, descriptor.getBytes(), StandardOpenOption.CREATE);
        }
        catch (IOException e) {
            throw new MojoExecutionException(String.format("There was an issue storing the dynamically generated descriptor file to [%s]", descriptorPath), (Exception)e);
        }
    }

    private File getModuleFile(String baseDirectory) throws MojoExecutionException {
        List modulesFiles = FileUtils.listFiles((File)new File(baseDirectory), (IOFileFilter)new FileFileFilter(){

            public boolean accept(File file) {
                return file.getName().startsWith(ExtensionDescriptorMojo.PREFIX_SMART_CONNECTOR_NAME) && file.getName().endsWith(ExtensionDescriptorMojo.SUFFIX_SMART_CONNECTOR_NAME);
            }
        }, (IOFileFilter)TrueFileFilter.INSTANCE).stream().filter(file -> this.getModule((File)file).isPresent()).collect(Collectors.toList());
        if (modulesFiles.size() > 1) {
            String xmlModules = String.join((CharSequence)"\n,", modulesFiles.stream().map(File::getAbsolutePath).collect(Collectors.toList()));
            throw new MojoExecutionException(String.format("There are several XML files that have a <module> root element, when there must be only one. Files with <module> as root element are: [%s]", xmlModules));
        }
        if (modulesFiles.isEmpty()) {
            throw new MojoExecutionException(String.format("There's no XML files that has a <module> root element, thus is impossible to auto generate a [%s] descriptor file. The file must start with [%s] and end with [%s], such as [%s]", "mule-plugin.json", PREFIX_SMART_CONNECTOR_NAME, SUFFIX_SMART_CONNECTOR_NAME, "module-foo.xml"));
        }
        return (File)modulesFiles.get(0);
    }

    private Optional<Document> getModule(File file) {
        Optional<Document> result = Optional.empty();
        DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
            Document doc = dBuilder.parse(file);
            if (doc.getDocumentElement().getNodeName().equals(MODULE_ROOT_ELEMENT)) {
                result = Optional.of(doc);
            }
        }
        catch (IOException | ParserConfigurationException | SAXException exception) {
            // empty catch block
        }
        return result;
    }
}

