/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.maven;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.building.ModelProblem;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.DefaultProjectBuildingRequest;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectBuilder;
import org.apache.maven.project.ProjectBuildingException;
import org.apache.maven.project.ProjectBuildingRequest;
import org.apache.maven.project.ProjectBuildingResult;
import org.apache.maven.repository.RepositorySystem;
import org.mule.plugin.maven.AbstractMuleMojo;

@Mojo(name="repository-mirror", defaultPhase=LifecyclePhase.VERIFY, requiresDependencyResolution=ResolutionScope.RUNTIME, threadSafe=true)
public class RepositoryMirrorMojo
extends AbstractMuleMojo {
    public static final String REPOSITORY_FOLDER = "repository";
    @Component
    private RepositorySystem repositorySystem;
    @Component
    private ProjectBuilder projectBuilder;
    @Parameter(readonly=true, required=true, defaultValue="${session}")
    private MavenSession session;
    @Parameter(readonly=true, required=true, defaultValue="${project.remoteArtifactRepositories}")
    private List<ArtifactRepository> remoteArtifactRepositories;
    @Parameter(readonly=true, required=true, defaultValue="${localRepository}")
    private ArtifactRepository localRepository;
    private ProjectBuildingRequest projectBuildingRequest;

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.getLog().info((CharSequence)String.format("Mirroring repository for [%s]", this.project.toString()));
        try {
            this.initializeProjectBuildingRequest();
            File repositoryFile = new File(this.outputDirectory, REPOSITORY_FOLDER);
            if (!repositoryFile.exists()) {
                repositoryFile.mkdirs();
            }
            HashSet<Artifact> artifacts = new HashSet<Artifact>(this.project.getArtifacts());
            for (Artifact dep : new ArrayList(artifacts)) {
                this.addThirdPartyParentPomArtifacts(artifacts, dep);
            }
            this.addParentPomArtifacts(artifacts);
            this.installArtifacts(repositoryFile, artifacts);
        }
        catch (Exception e) {
            if (this.getLog().isDebugEnabled()) {
                this.getLog().debug((CharSequence)String.format("There was an exception while building [%s]", this.project.toString()), (Throwable)e);
            }
            throw e;
        }
    }

    private void addThirdPartyParentPomArtifacts(Set<Artifact> artifacts, Artifact dep) throws MojoExecutionException {
        MavenProject project = this.buildProjectFromArtifact(dep);
        this.addParentDependencyPomArtifacts(project, artifacts);
        Artifact pomArtifact = this.repositorySystem.createProjectArtifact(dep.getGroupId(), dep.getArtifactId(), dep.getVersion());
        artifacts.add(this.getResolvedArtifactUsingLocalRepository(pomArtifact));
    }

    private void installArtifacts(File repositoryFile, Set<Artifact> artifacts) throws MojoExecutionException {
        ArrayList<Artifact> sortedArtifacts = new ArrayList<Artifact>(artifacts);
        Collections.sort(sortedArtifacts);
        if (sortedArtifacts.isEmpty()) {
            File markerFile = new File(repositoryFile, ".marker");
            this.getLog().info((CharSequence)String.format("No artifacts to add, adding marker file <%s/%s>", REPOSITORY_FOLDER, markerFile.getName()));
            try {
                markerFile.createNewFile();
            }
            catch (IOException e) {
                throw new MojoExecutionException(String.format("The current repository has no artifacts to install, and trying to create [%s] failed", markerFile.toString()), (Exception)e);
            }
        }
        for (Artifact artifact : sortedArtifacts) {
            this.installArtifact(repositoryFile, artifact);
        }
    }

    private void initializeProjectBuildingRequest() {
        this.projectBuildingRequest = new DefaultProjectBuildingRequest(this.session.getProjectBuildingRequest());
        this.projectBuildingRequest.setLocalRepository(this.localRepository);
        this.projectBuildingRequest.setRemoteRepositories(this.remoteArtifactRepositories);
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((CharSequence)String.format("Local repository [%s]", this.projectBuildingRequest.getLocalRepository().getBasedir()));
            this.projectBuildingRequest.getRemoteRepositories().stream().forEach(artifactRepository -> this.getLog().debug((CharSequence)String.format("Remote repository ID [%s], URL [%s]", artifactRepository.getId(), artifactRepository.getUrl())));
        }
    }

    private void installArtifact(File repositoryFile, Artifact artifact) throws MojoExecutionException {
        File artifactFolderDestination = RepositoryMirrorMojo.getFormattedOutputDirectory(repositoryFile, artifact);
        String artifactFilename = this.getFormattedFileName(artifact);
        if (!artifactFolderDestination.exists()) {
            artifactFolderDestination.mkdirs();
        }
        File destinationArtifactFile = new File(artifactFolderDestination, artifactFilename);
        try {
            this.getLog().info((CharSequence)String.format("Adding artifact <%s%s>", REPOSITORY_FOLDER, destinationArtifactFile.getAbsolutePath().replaceFirst(Pattern.quote(repositoryFile.getAbsolutePath()), "")));
            FileUtils.copyFile((File)artifact.getFile(), (File)destinationArtifactFile);
        }
        catch (IOException e) {
            throw new MojoExecutionException(String.format("There was a problem while copying the artifact [%s] file [%s] to the destination [%s]", artifact.toString(), artifact.getFile().getAbsolutePath(), destinationArtifactFile.getAbsolutePath()), (Exception)e);
        }
    }

    private MavenProject buildProjectFromArtifact(Artifact artifact) throws MojoExecutionException {
        MavenProject mavenProject;
        Artifact projectArtifact = this.repositorySystem.createProjectArtifact(artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion());
        try {
            mavenProject = this.projectBuilder.build(projectArtifact, this.projectBuildingRequest).getProject();
        }
        catch (ProjectBuildingException e) {
            this.getLog().warn((CharSequence)String.format("The artifact [%s] seems to have some warnings, enable logs for more information", artifact.toString()));
            if (this.getLog().isDebugEnabled()) {
                this.getLog().warn((CharSequence)String.format("The artifact [%s] had the following issue ", artifact.toString()), (Throwable)e);
            }
            if (e.getResults() == null || e.getResults().size() != 1) {
                throw new MojoExecutionException(String.format("There was an issue while trying to create a maven project from the artifact [%s]", artifact.toString()), (Exception)((Object)e));
            }
            ProjectBuildingResult projectBuildingResult = (ProjectBuildingResult)e.getResults().get(0);
            List collect = projectBuildingResult.getProblems().stream().filter(modelProblem -> modelProblem.getSeverity().equals((Object)ModelProblem.Severity.FATAL)).collect(Collectors.toList());
            if (!collect.isEmpty()) {
                throw new MojoExecutionException(String.format("There was an issue while trying to create a maven project from the artifact [%s], several FATAL errors were found", artifact.toString()), (Exception)((Object)e));
            }
            mavenProject = projectBuildingResult.getProject();
        }
        return mavenProject;
    }

    private void addParentDependencyPomArtifacts(MavenProject projectDependency, Set<Artifact> artifacts) throws MojoExecutionException {
        Artifact pomArtifact;
        MavenProject currentProject = projectDependency;
        while (currentProject.hasParent() && artifacts.add(this.getResolvedArtifactUsingLocalRepository(pomArtifact = (currentProject = currentProject.getParent()).getArtifact()))) {
        }
    }

    private void addParentPomArtifacts(Set<Artifact> artifacts) throws MojoExecutionException {
        MavenProject currentProject = this.project;
        boolean projectParent = true;
        while (currentProject.hasParent() && projectParent) {
            if ((currentProject = currentProject.getParent()).getFile() == null) {
                projectParent = false;
                continue;
            }
            Artifact pomArtifact = currentProject.getArtifact();
            pomArtifact.setFile(currentProject.getFile());
            this.validatePomArtifactFile(pomArtifact);
            if (artifacts.add(pomArtifact)) continue;
            break;
        }
        if (!projectParent) {
            Artifact unresolvedParentPomArtifact = currentProject.getArtifact();
            this.addThirdPartyParentPomArtifacts(artifacts, unresolvedParentPomArtifact);
        }
    }

    private Artifact getResolvedArtifactUsingLocalRepository(Artifact pomArtifact) throws MojoExecutionException {
        Artifact resolvedPomArtifact = this.localRepository.find(pomArtifact);
        this.validatePomArtifactFile(resolvedPomArtifact);
        return resolvedPomArtifact;
    }

    private void validatePomArtifactFile(Artifact resolvedPomArtifact) throws MojoExecutionException {
        if (resolvedPomArtifact.getFile() == null) {
            throw new MojoExecutionException(String.format("There was a problem trying to resolve the artifact's file location for [%s], file was null", resolvedPomArtifact.toString()));
        }
        if (!resolvedPomArtifact.getFile().exists()) {
            throw new MojoExecutionException(String.format("There was a problem trying to resolve the artifact's file location for [%s], file [%s] doesn't exists", resolvedPomArtifact.toString(), resolvedPomArtifact.getFile().getAbsolutePath()));
        }
    }

    private String getFormattedFileName(Artifact artifact) {
        StringBuilder destFileName = new StringBuilder();
        String versionString = "-" + this.getNormalizedVersion(artifact);
        String classifierString = "";
        if (artifact.getClassifier() != null && !artifact.getClassifier().isEmpty()) {
            classifierString = "-" + artifact.getClassifier();
        }
        destFileName.append(artifact.getArtifactId()).append(versionString);
        destFileName.append(classifierString).append(".");
        destFileName.append(artifact.getArtifactHandler().getExtension());
        return destFileName.toString();
    }

    private String getNormalizedVersion(Artifact artifact) {
        if (artifact.isSnapshot() && !artifact.getVersion().equals(artifact.getBaseVersion())) {
            return artifact.getBaseVersion();
        }
        return artifact.getVersion();
    }

    private static File getFormattedOutputDirectory(File outputDirectory, Artifact artifact) {
        StringBuilder sb = new StringBuilder(128);
        sb.append(artifact.getGroupId().replace('.', File.separatorChar)).append(File.separatorChar);
        sb.append(artifact.getArtifactId()).append(File.separatorChar);
        sb.append(artifact.getBaseVersion()).append(File.separatorChar);
        return new File(outputDirectory, sb.toString());
    }
}

