/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.maven.documentation;

import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.mule.runtime.api.meta.DescribedObject;
import org.mule.runtime.api.meta.NamedObject;
import org.mule.runtime.api.meta.model.display.DisplayModel;
import org.mule.runtime.api.meta.model.display.HasDisplayModel;

public class NameUtils {
    public static String prettify(NamedObject component) {
        return NameUtils.getDisplayName((HasDisplayModel)component).orElse(NameUtils.prettify(component.getName()));
    }

    public static String prettify(String name) {
        StringBuilder pretty = new StringBuilder();
        boolean shouldCapitalizeNext = true;
        for (int i = 0; i < name.length(); ++i) {
            char c = name.charAt(i);
            if (c == '-' || Character.isWhitespace(c)) {
                shouldCapitalizeNext = true;
                pretty.append(" ");
                continue;
            }
            if (NameUtils.shouldAddWhitespace(name, i, c) && !NameUtils.endsWithWhitespace(pretty)) {
                pretty.append(" ");
            }
            if (shouldCapitalizeNext) {
                pretty.append(Character.toUpperCase(c));
                shouldCapitalizeNext = false;
                continue;
            }
            pretty.append(c);
        }
        return pretty.toString().trim();
    }

    private static Optional<String> getDisplayName(HasDisplayModel model) {
        Optional displayModel = model.getDisplayModel();
        return displayModel.isPresent() && !StringUtils.isBlank((CharSequence)((DisplayModel)displayModel.get()).getDisplayName()) ? Optional.ofNullable(((DisplayModel)displayModel.get()).getDisplayName()) : Optional.empty();
    }

    public static Optional<String> getDescription(HasDisplayModel model, DescribedObject describedObject) {
        Optional<String> optionalDescription = Optional.empty();
        String description = describedObject.getDescription();
        if (!StringUtils.isBlank((CharSequence)description)) {
            optionalDescription = Optional.of(description);
        } else {
            Optional displayModel = model.getDisplayModel();
            if (displayModel.isPresent() && !StringUtils.isBlank((CharSequence)((DisplayModel)displayModel.get()).getSummary())) {
                optionalDescription = Optional.of(((DisplayModel)displayModel.get()).getSummary());
            }
        }
        return optionalDescription;
    }

    private static boolean shouldAddWhitespace(String name, int i, char c) {
        return Character.isUpperCase(c) && (!NameUtils.previousIsUppercase(name, i) || NameUtils.previousIsUppercase(name, i) && NameUtils.nextIsLowercase(name, i));
    }

    private static boolean previousIsUppercase(String name, int i) {
        return i > 0 && Character.isUpperCase(name.charAt(i - 1));
    }

    private static boolean nextIsLowercase(String name, int i) {
        return i < name.length() - 1 && Character.isLowerCase(name.charAt(i + 1));
    }

    private static boolean endsWithWhitespace(StringBuilder builder) {
        return builder.length() > 0 && Character.isWhitespace(builder.charAt(builder.length() - 1));
    }
}

