/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.maven.documentation.types;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.mule.extension.maven.documentation.types.ObjectTypeUtils;
import org.mule.extension.maven.documentation.types.TypeParserVisitor;
import org.mule.extension.maven.documentation.types.TypeRegister;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.visitor.MetadataTypeVisitor;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.parameter.ParameterModel;

public class TypeFlattener {
    private final TypeRegister register;

    public TypeFlattener(ExtensionModel extension) {
        this.register = new TypeRegister(extension);
    }

    public String flat(ParameterModel param) {
        return this.flat(param.getType());
    }

    public String flat(MetadataType type) {
        TypeParserVisitor visitor = new TypeParserVisitor(this.register.getSubtypes());
        type.accept((MetadataTypeVisitor)visitor);
        return (String)visitor.holder.get();
    }

    public Map<String, String> getObjectTypes() {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        this.register.getTypes().forEach((key, value) -> builder.put(key, (Object)ObjectTypeUtils.toAsciidoc(value, this)));
        return builder.build();
    }
}

