/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.maven.documentation.types;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import org.mule.extension.maven.documentation.types.ObjectTypeUtils;
import org.mule.metadata.api.annotation.EnumAnnotation;
import org.mule.metadata.api.model.AnyType;
import org.mule.metadata.api.model.ArrayType;
import org.mule.metadata.api.model.BinaryType;
import org.mule.metadata.api.model.BooleanType;
import org.mule.metadata.api.model.DateTimeType;
import org.mule.metadata.api.model.DateType;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.NullType;
import org.mule.metadata.api.model.NumberType;
import org.mule.metadata.api.model.ObjectFieldType;
import org.mule.metadata.api.model.ObjectType;
import org.mule.metadata.api.model.RegexType;
import org.mule.metadata.api.model.StringType;
import org.mule.metadata.api.model.UnionType;
import org.mule.metadata.api.model.VoidType;
import org.mule.metadata.api.visitor.MetadataTypeVisitor;
import org.mule.runtime.api.util.Reference;
import org.mule.runtime.extension.api.util.ExtensionMetadataTypeUtils;

public class TypeParserVisitor
extends MetadataTypeVisitor {
    Reference<String> holder = new Reference();
    private Map<String, List<String>> subtypesIdMap;

    TypeParserVisitor(Map<String, List<String>> subtypesIdMap) {
        this.subtypesIdMap = subtypesIdMap;
    }

    protected void defaultVisit(MetadataType metadataType) {
        this.holder.set((Object)"String");
    }

    public void visitAnyType(AnyType anyType) {
        this.holder.set((Object)"Any");
    }

    public void visitArrayType(ArrayType arrayType) {
        arrayType.getType().accept((MetadataTypeVisitor)this);
        this.holder.set((Object)("Array of " + (String)this.holder.get()));
    }

    public void visitBinaryType(BinaryType binaryType) {
        this.holder.set((Object)"Binary");
    }

    public void visitBoolean(BooleanType booleanType) {
        this.holder.set((Object)"Boolean");
    }

    public void visitDateTime(DateTimeType dateTimeType) {
        this.holder.set((Object)"DateTime");
    }

    public void visitDate(DateType dateType) {
        this.holder.set((Object)"Date");
    }

    public void visitNull(NullType nullType) {
        this.holder.set((Object)"Null");
    }

    public void visitVoid(VoidType voidType) {
        this.holder.set((Object)"Void");
    }

    public void visitNumber(NumberType numberType) {
        this.holder.set((Object)"Number");
    }

    public void visitObject(ObjectType objectType) {
        if (ExtensionMetadataTypeUtils.isMap((MetadataType)objectType)) {
            this.holder.set((Object)"Object");
            return;
        }
        if (ObjectTypeUtils.isMessage(objectType)) {
            Iterator fields = objectType.getFields().iterator();
            if (fields.hasNext()) {
                ((ObjectFieldType)fields.next()).getValue().accept((MetadataTypeVisitor)this);
                String payload = (String)this.holder.get();
                ((ObjectFieldType)fields.next()).getValue().accept((MetadataTypeVisitor)this);
                String atts = (String)this.holder.get();
                this.holder.set((Object)String.format("Message of [%s] payload and [%s] attributes", payload, atts));
            } else {
                this.holder.set((Object)"Message");
            }
            return;
        }
        Optional<String> objectTypeId = ObjectTypeUtils.getObjectTypeId(objectType);
        if (objectTypeId.isPresent()) {
            String id = objectTypeId.get();
            if (this.subtypesIdMap.containsKey(id)) {
                StringJoiner builder = new StringJoiner("\n");
                builder.add("One of:\n");
                this.subtypesIdMap.get(id).forEach(subtype -> builder.add("* <<" + subtype + ">>"));
                this.holder.set((Object)builder.toString());
            } else {
                this.holder.set((Object)("<<" + id + ">>"));
            }
        } else {
            this.holder.set((Object)"Any");
        }
    }

    public void visitString(StringType stringType) {
        Optional enumAnnotation = stringType.getAnnotation(EnumAnnotation.class);
        if (enumAnnotation.isPresent()) {
            StringJoiner builder = new StringJoiner("\n");
            builder.add("Enumeration, one of:\n");
            for (Object value : ((EnumAnnotation)enumAnnotation.get()).getValues()) {
                builder.add("** " + value.toString());
            }
            this.holder.set((Object)builder.toString());
        } else {
            this.holder.set((Object)"String");
        }
    }

    public void visitRegex(RegexType regexType) {
        this.holder.set((Object)"Regex");
    }

    public void visitUnion(UnionType unionType) {
        List<String> types = unionType.getTypes().stream().map(t -> {
            t.accept((MetadataTypeVisitor)this);
            return (String)this.holder.get();
        }).collect(Collectors.toList());
        StringJoiner union = new StringJoiner("\n");
        types.forEach(t -> union.add("* " + t));
        this.holder.set((Object)union.toString());
    }
}

