/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.maven;

import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.FileFileFilter;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.TrueFileFilter;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.mule.extension.maven.ExtensionPackageMojo;
import org.mule.extension.maven.loader.MulePluginJsonDescriberLoader;
import org.mule.plugin.maven.AbstractMuleMojo;
import org.mule.runtime.api.deployment.meta.AbstractMuleArtifactModel;
import org.mule.runtime.api.deployment.meta.MuleArtifactLoaderDescriptor;
import org.mule.runtime.api.deployment.meta.MulePluginModel;
import org.mule.runtime.api.deployment.meta.Product;
import org.mule.runtime.api.deployment.persistence.MulePluginModelJsonSerializer;
import org.mule.runtime.api.meta.MuleVersion;
import org.mule.runtime.api.util.Preconditions;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

@Mojo(name="extension-descriptor", defaultPhase=LifecyclePhase.COMPILE, threadSafe=true)
public class ExtensionDescriptorMojo
extends AbstractMuleMojo {
    private static final String META_INF = "META-INF";
    private static final String AUTO_GENERATED_MULE_ARTIFACT_DESCRIPTOR = Paths.get("META-INF", "auto-generated-mule-artifact.json").toString();
    private static final String TEMPORARY_XML_VALIDATION_MULE_ARTIFACT_JSON = "temporal-compile-mule-artifact.json";
    private static final String MULE_LOADER_ID = "mule";
    public static final String XML_BASED_EXTENSION_MODEL_LOADER = "xml-based";
    public static final String RESOURCE_XML = "resource-xml";
    private static final String VALIDATE_XML = "validate-xml";
    private static final String PREFIX_SMART_CONNECTOR_NAME = "module-";
    private static final String SUFFIX_SMART_CONNECTOR_NAME = ".xml";
    private static final String MODULE_ROOT_ELEMENT = "module";
    private static final String NAME_ATTRIBUTE = "name";
    private static final String MIN_MULE_VERSION_ATTRIBUTE = "minMuleVersion";
    private static final String MIN_MULE_VERSION_DESCRIPTOR_PROPERTY = "minMuleVersion";
    private static final String REQUIRED_PRODUCT_DESCRIPTOR_PROPERTY = "requiredProduct";
    private static final String DEFAULT_MIN_MULE_VERSION = "4.0.0";
    private static final String MULE_CE_PRODUCT = "MULE";
    private static final String MULE_EE_PRODUCT = "MULE_EE";

    public static Path descriptorPathOrFail(File outputDirectory) throws MojoFailureException {
        return ExtensionDescriptorMojo.descriptorPath(outputDirectory, "classes" + File.separator + ExtensionPackageMojo.MULE_PLUGIN_JSON_JAR_DESTINATION);
    }

    public static Path autoGeneratedDescriptorPath(File outputDirectory) throws MojoFailureException {
        return Paths.get(outputDirectory.getAbsolutePath(), AUTO_GENERATED_MULE_ARTIFACT_DESCRIPTOR);
    }

    public static Path descriptorForXmlModuleValidationOrFail(File outputDirectory) throws MojoFailureException {
        return ExtensionDescriptorMojo.descriptorPath(outputDirectory, TEMPORARY_XML_VALIDATION_MULE_ARTIFACT_JSON);
    }

    public static Path descriptorForXmlModuleValidation(File outputDirectory) throws MojoFailureException {
        return Paths.get(outputDirectory.getAbsolutePath(), TEMPORARY_XML_VALIDATION_MULE_ARTIFACT_JSON);
    }

    private static Path descriptorPath(File outputDirectory, String descriptorLocation) throws MojoFailureException {
        Path path = Paths.get(outputDirectory.getAbsolutePath(), descriptorLocation);
        if (Files.notExists(path, new LinkOption[0])) {
            throw new MojoFailureException(String.format("Should not have reach this point, could not obtain descriptor file from [%s]", path));
        }
        return path;
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        Path targetDescriptorPath;
        Path autoGeneratedDescriptorPath;
        block4: {
            autoGeneratedDescriptorPath = ExtensionDescriptorMojo.autoGeneratedDescriptorPath(new File(this.project.getBuild().getOutputDirectory()));
            targetDescriptorPath = Paths.get(this.project.getBuild().getOutputDirectory(), META_INF, "mule-artifact", "mule-artifact.json");
            Path descriptorForXmlModuleValidation = ExtensionDescriptorMojo.descriptorForXmlModuleValidation(this.outputDirectory);
            if (!Files.exists(autoGeneratedDescriptorPath, new LinkOption[0])) {
                this.getLog().info((CharSequence)String.format("No [%s] descriptor found, trying to create one", targetDescriptorPath));
                try {
                    this.createDescriptor(autoGeneratedDescriptorPath, descriptorForXmlModuleValidation);
                }
                catch (MojoExecutionException e) {
                    if (Files.exists(targetDescriptorPath, new LinkOption[0])) break block4;
                    throw e;
                }
            }
        }
        this.applyUserCustomizedPropertiesAndDefaultValues(targetDescriptorPath, autoGeneratedDescriptorPath);
        MulePluginModel mulePluginModel = MulePluginJsonDescriberLoader.loadMulePluginDescriber(this.outputDirectory);
        this.validate(mulePluginModel);
        if (Files.exists(autoGeneratedDescriptorPath, new LinkOption[0])) {
            FileUtils.deleteQuietly((File)autoGeneratedDescriptorPath.toFile());
        }
    }

    private void validate(MulePluginModel mulePluginModel) {
        mulePluginModel.getLicense().ifPresent(licenseModel -> licenseModel.getRequiredEntitlement().ifPresent(requiredEntitlement -> {
            String provider = licenseModel.getProvider();
            String outputDirectory = this.project.getBuild().getOutputDirectory();
            String keyFileName = String.format("%s-%s.key", provider, StringUtils.uncapitalize((String)mulePluginModel.getName().replace(" ", "")));
            if (!new File(outputDirectory, keyFileName).exists()) {
                throw new RuntimeException(String.format("The plugin requires an entitlement but there is no key file (%s) found. The provider key file for customer licenses must be added to the classpath at the root level", keyFileName));
            }
        }));
    }

    private void applyUserCustomizedPropertiesAndDefaultValues(Path targetDescriptorPath, Path autoGeneratedDescriptorPath) throws MojoExecutionException {
        String minMuleVersion = DEFAULT_MIN_MULE_VERSION;
        String requiredProduct = MULE_CE_PRODUCT;
        JsonElement targetDescriptorJsonElement = Files.exists(autoGeneratedDescriptorPath, new LinkOption[0]) ? this.getJsonElement(autoGeneratedDescriptorPath) : this.getJsonElement(targetDescriptorPath);
        if (targetDescriptorJsonElement.getAsJsonObject().has(REQUIRED_PRODUCT_DESCRIPTOR_PROPERTY)) {
            requiredProduct = targetDescriptorJsonElement.getAsJsonObject().get(REQUIRED_PRODUCT_DESCRIPTOR_PROPERTY).getAsString();
        }
        if (Files.exists(targetDescriptorPath, new LinkOption[0])) {
            MuleVersion muleVersion;
            JsonElement userCustomizedDescriptorJsonElement = this.getJsonElement(targetDescriptorPath);
            if (userCustomizedDescriptorJsonElement.getAsJsonObject().has("minMuleVersion")) {
                minMuleVersion = userCustomizedDescriptorJsonElement.getAsJsonObject().get("minMuleVersion").getAsString();
            }
            Preconditions.checkState((!(muleVersion = new MuleVersion(minMuleVersion)).hasSuffix() ? 1 : 0) != 0, (String)"minMuleVersion cannot have suffix");
            if (userCustomizedDescriptorJsonElement.getAsJsonObject().has(REQUIRED_PRODUCT_DESCRIPTOR_PROPERTY)) {
                requiredProduct = userCustomizedDescriptorJsonElement.getAsJsonObject().get(REQUIRED_PRODUCT_DESCRIPTOR_PROPERTY).getAsString();
                Preconditions.checkState((requiredProduct.equals(MULE_CE_PRODUCT) || requiredProduct.equals(MULE_EE_PRODUCT) ? 1 : 0) != 0, (String)String.format("%s is invalid, value is %s and valid values are (%s, %s)", REQUIRED_PRODUCT_DESCRIPTOR_PROPERTY, requiredProduct, MULE_CE_PRODUCT, MULE_EE_PRODUCT));
            }
        }
        targetDescriptorJsonElement.getAsJsonObject().addProperty("minMuleVersion", minMuleVersion);
        targetDescriptorJsonElement.getAsJsonObject().addProperty(REQUIRED_PRODUCT_DESCRIPTOR_PROPERTY, requiredProduct);
        try {
            targetDescriptorPath.getParent().toFile().mkdirs();
            Files.write(targetDescriptorPath, new GsonBuilder().setPrettyPrinting().create().toJson(targetDescriptorJsonElement).getBytes(), StandardOpenOption.CREATE);
        }
        catch (IOException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)e);
        }
    }

    private JsonElement getJsonElement(Path targetDescriptorPath) throws MojoExecutionException {
        byte[] descriptorContent;
        try {
            descriptorContent = Files.readAllBytes(targetDescriptorPath);
        }
        catch (IOException e) {
            throw new MojoExecutionException("failure opening file " + targetDescriptorPath.toFile().getAbsolutePath(), (Exception)e);
        }
        JsonParser parser = new JsonParser();
        return parser.parse(new String(descriptorContent));
    }

    private void createDescriptor(Path descriptorTargetPath, Path descriptorForXmlValidationTargetPath) throws MojoExecutionException {
        String baseDirectory = this.project.getBuild().getOutputDirectory();
        File moduleFile = this.getModuleFile(baseDirectory);
        this.getLog().info((CharSequence)String.format("Generating [%s] descriptor for the <module> found in [%s]", "mule-artifact.json", moduleFile.getAbsolutePath()));
        Document doc = this.getModule(moduleFile).get();
        String name = doc.getDocumentElement().getAttribute(NAME_ATTRIBUTE);
        if (StringUtils.isBlank((CharSequence)name)) {
            throw new MojoExecutionException(String.format("There was an issue storing the dynamically generated descriptor file to [%s]", descriptorTargetPath));
        }
        String relativeModuleFileName = moduleFile.getAbsolutePath().substring(baseDirectory.length() + 1, moduleFile.getAbsolutePath().length());
        this.createDescriptor(descriptorTargetPath, name, relativeModuleFileName, doc, false);
        this.createDescriptor(descriptorForXmlValidationTargetPath, name, relativeModuleFileName, doc, true);
    }

    private void createDescriptor(Path descriptorPath, String name, String resourceXml, Document moduleDocument, boolean validateXml) throws MojoExecutionException {
        MulePluginModel.MulePluginModelBuilder mulePluginModelBuilder = (MulePluginModel.MulePluginModelBuilder)new MulePluginModel.MulePluginModelBuilder().setName(name);
        mulePluginModelBuilder.withBundleDescriptorLoader(new MuleArtifactLoaderDescriptor(MULE_LOADER_ID, Collections.emptyMap()));
        mulePluginModelBuilder.withClassLoaderModelDescriptorLoader(new MuleArtifactLoaderDescriptor(MULE_LOADER_ID, Collections.emptyMap()));
        mulePluginModelBuilder.withExtensionModelDescriber().setId(XML_BASED_EXTENSION_MODEL_LOADER).addProperty(RESOURCE_XML, (Object)resourceXml).addProperty(VALIDATE_XML, (Object)validateXml);
        Element moduleElement = moduleDocument.getDocumentElement();
        String category = moduleElement.getAttribute("category");
        String vendor = moduleElement.getAttribute("vendor");
        String requiredEntitlement = moduleElement.getAttribute("requiredEntitlement");
        String allowsEvaluationLicense = moduleElement.getAttribute("allowsEvaluationLicense");
        mulePluginModelBuilder.setRequiredProduct(StringUtils.isBlank((CharSequence)category) || "COMMUNITY".equals(category) ? Product.MULE : Product.MULE_EE);
        if (!StringUtils.isBlank((CharSequence)requiredEntitlement)) {
            mulePluginModelBuilder.withLicenseModel().setRequiredEntitlement(requiredEntitlement).setProvider(StringUtils.isBlank((CharSequence)vendor) ? "MuleSoft" : vendor).setAllowsEvaluationLicense(StringUtils.isBlank((CharSequence)allowsEvaluationLicense) || "true".equals(allowsEvaluationLicense));
        }
        MulePluginModel build = mulePluginModelBuilder.build();
        String descriptor = new MulePluginModelJsonSerializer().serialize((AbstractMuleArtifactModel)build);
        try {
            descriptorPath.getParent().toFile().mkdirs();
            Files.write(descriptorPath, descriptor.getBytes(), StandardOpenOption.CREATE);
        }
        catch (IOException e) {
            throw new MojoExecutionException(String.format("There was an issue storing the dynamically generated descriptor file to [%s]", descriptorPath), (Exception)e);
        }
    }

    private File getModuleFile(String baseDirectory) throws MojoExecutionException {
        List modulesFiles = FileUtils.listFiles((File)new File(baseDirectory), (IOFileFilter)new FileFileFilter(){

            public boolean accept(File file) {
                return file.getName().startsWith(ExtensionDescriptorMojo.PREFIX_SMART_CONNECTOR_NAME) && file.getName().endsWith(ExtensionDescriptorMojo.SUFFIX_SMART_CONNECTOR_NAME);
            }
        }, (IOFileFilter)TrueFileFilter.INSTANCE).stream().filter(file -> this.getModule((File)file).isPresent()).collect(Collectors.toList());
        if (modulesFiles.size() > 1) {
            String xmlModules = String.join((CharSequence)"\n,", modulesFiles.stream().map(File::getAbsolutePath).collect(Collectors.toList()));
            throw new MojoExecutionException(String.format("There are several XML files that have a <module> root element, when there must be only one. Files with <module> as root element are: [%s]", xmlModules));
        }
        if (modulesFiles.isEmpty()) {
            throw new MojoExecutionException(String.format("There's no XML files that has a <module> root element, thus is impossible to auto generate a [%s] descriptor file. The file must start with [%s] and end with [%s], such as [%s]", "mule-artifact.json", PREFIX_SMART_CONNECTOR_NAME, SUFFIX_SMART_CONNECTOR_NAME, "module-foo.xml"));
        }
        return (File)modulesFiles.get(0);
    }

    private Optional<Document> getModule(File file) {
        Optional<Document> result = Optional.empty();
        DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
            Document doc = dBuilder.parse(file);
            if (doc.getDocumentElement().getNodeName().equals(MODULE_ROOT_ELEMENT)) {
                result = Optional.of(doc);
            }
        }
        catch (IOException | ParserConfigurationException | SAXException exception) {
            // empty catch block
        }
        return result;
    }
}

