/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.extension.maven.documentation.types;

import org.mule.extension.maven.documentation.internal.model.XmlExtensionDocumentation;
import org.mule.metadata.api.model.MetadataType;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.parameter.ParameterModel;

import com.google.common.collect.ImmutableMap;

import java.util.Map;

/**
 * Parses a {@link MetadataType} so it can be populated in the generated documentation.
 */
public class TypeFlattener {

  private final TypeRegister register;
  private final XmlExtensionDocumentation xmlDocumentation;

  public TypeFlattener(ExtensionModel extension,
                       XmlExtensionDocumentation xmlDocumentation) {
    this.register = new TypeRegister(extension);
    this.xmlDocumentation = xmlDocumentation;
  }

  public String flat(ParameterModel param) {
    return flat(param.getType());
  }

  public String flat(MetadataType type) {
    TypeParserVisitor visitor = new TypeParserVisitor(register.getSubtypes());
    type.accept(visitor);
    return visitor.holder.get();
  }

  public Map<String, String> getObjectTypes() {
    ImmutableMap.Builder<String, String> builder = ImmutableMap.builder();
    register.getTypes().forEach((key, value) -> builder.put(key, ObjectTypeUtils.toAsciidoc(value, this, xmlDocumentation)));
    return builder.build();
  }
}
