/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */

package org.mule.extension.maven;

import static java.nio.file.Paths.get;
import static org.apache.commons.io.FileUtils.copyFile;
import static org.mockito.Matchers.anyObject;
import static org.mockito.Mockito.mock;
import static org.mockito.Mockito.when;
import static org.mule.plugin.maven.AbstractMuleMojo.MULE_ARTIFACT;
import static org.mule.plugin.maven.AbstractMuleMojo.MULE_ARTIFACT_JSON;
import static org.powermock.api.mockito.PowerMockito.mockStatic;

import java.io.File;
import java.nio.file.Path;
import java.util.Properties;

import org.apache.maven.model.Build;
import org.apache.maven.project.MavenProject;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.rules.TemporaryFolder;
import org.junit.runner.RunWith;
import org.powermock.api.mockito.PowerMockito;
import org.powermock.core.classloader.annotations.PrepareForTest;
import org.powermock.modules.junit4.PowerMockRunner;

@RunWith(PowerMockRunner.class)
@PrepareForTest({ExtensionDescriptorMojo.class})
public class ExtensionDescriptorMojoTest {

  private static final String MULE_ARTIFACT_JSON_LOCATION = get("META-INF", MULE_ARTIFACT, MULE_ARTIFACT_JSON).toString();
  public static final String MULE_VERSION_PROPERTY = "mule.version";
  public static final String MULE_VERSION = "4.2.0-SNAPSHOT";
  public static final String PROJECT_VERSION = "1.1.0-SNAPSHOT";

  private MavenProject projectMock;
  private Build buildMock;
  private Properties props;

  private ExtensionDescriptorMojo mojo;

  @Rule
  public TemporaryFolder projectBaseFolder = new TemporaryFolder();

  @Rule
  public TemporaryFolder buildFolderFolder = new TemporaryFolder();

  @Rule
  public ExpectedException expectedException = ExpectedException.none();

  @Before
  public void setUp() throws Exception {
    mojo = new ExtensionDescriptorMojo();

    projectMock = mock(MavenProject.class);
    buildMock = mock(Build.class);
    props = mock(Properties.class);

    mojo.project = projectMock;

    when(projectMock.getBuild()).thenReturn(buildMock);
    when(projectMock.getProperties()).thenReturn(props);
    when(projectMock.getVersion()).thenReturn(PROJECT_VERSION);
    when(buildMock.getOutputDirectory()).thenReturn(buildFolderFolder.getRoot().getAbsolutePath());
    when(props.get(MULE_VERSION_PROPERTY)).thenReturn(MULE_VERSION);
  }

  @Test
  public void testMuleArtifactGetsProperlyGenerated() throws Exception {
    String buildFolderPath = buildFolderFolder.getRoot().getAbsolutePath();
    Path muleArtifactAbsolutePath = get(buildFolderPath, MULE_ARTIFACT_JSON_LOCATION);

    mockStatic(ExtensionDescriptorMojo.class);
    PowerMockito.when(ExtensionDescriptorMojo.descriptorPathOrFail(anyObject())).thenReturn(muleArtifactAbsolutePath);
    PowerMockito.when(ExtensionDescriptorMojo.autoGeneratedDescriptorPath(anyObject())).thenCallRealMethod();

    copyFile(new File(ExtensionDescriptorMojoTest.class.getClassLoader().getResource(MULE_ARTIFACT_JSON).getFile()),
             get(buildFolderPath, MULE_ARTIFACT_JSON_LOCATION).toFile());

    mojo.execute();
  }
}
