/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.maven;

import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import jdk.nashorn.internal.objects.NativeArray;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.FileFileFilter;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.TrueFileFilter;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.mule.extension.maven.ExtensionPackageMojo;
import org.mule.extension.maven.loader.MulePluginJsonDescriberLoader;
import org.mule.extension.maven.util.MulePluginArtifactLoaderUtils;
import org.mule.plugin.maven.AbstractMuleMojo;
import org.mule.runtime.api.deployment.meta.AbstractMuleArtifactModel;
import org.mule.runtime.api.deployment.meta.MuleArtifactLoaderDescriptor;
import org.mule.runtime.api.deployment.meta.MuleArtifactLoaderDescriptorBuilder;
import org.mule.runtime.api.deployment.meta.MulePluginModel;
import org.mule.runtime.api.deployment.meta.Product;
import org.mule.runtime.api.deployment.persistence.MulePluginModelJsonSerializer;
import org.mule.runtime.api.meta.Category;
import org.mule.runtime.api.meta.MuleVersion;
import org.mule.runtime.api.meta.model.XmlDslModel;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.extension.api.util.XmlModelUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

@Mojo(name="extension-descriptor", defaultPhase=LifecyclePhase.COMPILE, threadSafe=true, requiresDependencyResolution=ResolutionScope.COMPILE)
public class ExtensionDescriptorMojo
extends AbstractMuleMojo {
    private static final String META_INF = "META-INF";
    private static final String AUTO_GENERATED_MULE_ARTIFACT_DESCRIPTOR = Paths.get("META-INF", "auto-generated-mule-artifact.json").toString();
    private static final String MULE_LOADER_ID = "mule";
    public static final String XML_BASED_EXTENSION_MODEL_LOADER = "xml-based";
    public static final String RESOURCE_XML = "resource-xml";
    public static final String VALIDATE_XML = "validate-xml";
    public static final String RESOURCES_PATHS = "resources-paths";
    private static final String PREFIX_SMART_CONNECTOR_NAME = "module-";
    private static final String SUFFIX_SMART_CONNECTOR_NAME = ".xml";
    private static final String MODULE_ROOT_ELEMENT = "module";
    private static final String NAME_ATTRIBUTE = "name";
    private static final String PREFIX_ATTRIBUTE = "prefix";
    private static final String CATEGORY_ATTRIBUTE = "category";
    private static final String MULE_VERSION_PROPERTY = "mule.version";
    private static final String MIN_MULE_VERSION_PROPERTY = "min.mule.version";
    private static final String SKIP_MULE_VERSION_SUFFIX_VALIDATION_PROPERTY = "mule.extensions.disableMuleVersionSuffixValidation";
    public static final String SNAPSHOT_SUFFIX = "SNAPSHOT";
    public static final String INTERNAL_FOLDER = "internal";
    public static final String EE_MULESOFT_ARTIFACTS_GROUP_ID_PREFIX = "com.mulesoft";

    public static Path descriptorPathOrFail(File outputDirectory) throws MojoFailureException {
        return ExtensionDescriptorMojo.descriptorPath(outputDirectory, "classes" + File.separator + ExtensionPackageMojo.MULE_PLUGIN_JSON_JAR_DESTINATION);
    }

    public static Path autoGeneratedDescriptorPath(File outputDirectory) throws MojoFailureException {
        return Paths.get(outputDirectory.getAbsolutePath(), AUTO_GENERATED_MULE_ARTIFACT_DESCRIPTOR);
    }

    private static Path descriptorPath(File outputDirectory, String descriptorLocation) throws MojoFailureException {
        Path path = Paths.get(outputDirectory.getAbsolutePath(), descriptorLocation);
        if (Files.notExists(path, new LinkOption[0])) {
            throw new MojoFailureException(String.format("Should not have reach this point, could not obtain descriptor file from [%s]", path));
        }
        return path;
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        Path targetDescriptorPath;
        Path autoGeneratedDescriptorPath;
        block4: {
            autoGeneratedDescriptorPath = ExtensionDescriptorMojo.autoGeneratedDescriptorPath(new File(this.project.getBuild().getOutputDirectory()));
            targetDescriptorPath = Paths.get(this.project.getBuild().getOutputDirectory(), META_INF, "mule-artifact", "mule-artifact.json");
            if (!Files.exists(autoGeneratedDescriptorPath, new LinkOption[0]) && !Files.exists(targetDescriptorPath, new LinkOption[0])) {
                this.getLog().debug((CharSequence)String.format("No [%s] descriptor found, trying to create one", targetDescriptorPath));
                try {
                    this.createDescriptor(autoGeneratedDescriptorPath);
                }
                catch (MojoExecutionException e) {
                    if (Files.exists(targetDescriptorPath, new LinkOption[0])) break block4;
                    throw e;
                }
            }
        }
        this.applyUserCustomizedPropertiesAndDefaultValues(targetDescriptorPath, autoGeneratedDescriptorPath);
        MulePluginModel mulePluginModel = MulePluginJsonDescriberLoader.loadMulePluginDescriber(this.outputDirectory);
        this.validate(mulePluginModel);
        if (Files.exists(autoGeneratedDescriptorPath, new LinkOption[0])) {
            FileUtils.deleteQuietly((File)autoGeneratedDescriptorPath.toFile());
        }
    }

    private void validate(MulePluginModel mulePluginModel) {
        mulePluginModel.getLicense().ifPresent(licenseModel -> licenseModel.getRequiredEntitlement().ifPresent(requiredEntitlement -> {
            String provider = licenseModel.getProvider();
            if (!"Mulesoft".equals(provider)) {
                String outputDirectory = this.project.getBuild().getOutputDirectory();
                String keyFileName = String.format("%s-%s.key", StringUtils.uncapitalize((String)provider.replace(" ", "")), mulePluginModel.getName());
                if (!new File(outputDirectory, keyFileName).exists()) {
                    throw new RuntimeException(String.format("The plugin requires an entitlement but there is no key file (%s) found. The provider key file for customer licenses must be added to the classpath at the root level", keyFileName));
                }
            }
        }));
    }

    private void applyUserCustomizedPropertiesAndDefaultValues(Path targetDescriptorPath, Path autoGeneratedDescriptorPath) throws MojoExecutionException {
        String minMuleVersion = this.resolveMinMuleVersion();
        String requiredProduct = Product.MULE.name();
        JsonElement targetDescriptorJsonElement = Files.exists(autoGeneratedDescriptorPath, new LinkOption[0]) ? this.getJsonElement(autoGeneratedDescriptorPath) : this.getJsonElement(targetDescriptorPath);
        if (targetDescriptorJsonElement.getAsJsonObject().has("requiredProduct")) {
            requiredProduct = targetDescriptorJsonElement.getAsJsonObject().get("requiredProduct").getAsString();
        }
        if (Files.exists(targetDescriptorPath, new LinkOption[0])) {
            JsonElement userCustomizedDescriptorJsonElement = this.getJsonElement(targetDescriptorPath);
            if (userCustomizedDescriptorJsonElement.getAsJsonObject().has("minMuleVersion")) {
                minMuleVersion = userCustomizedDescriptorJsonElement.getAsJsonObject().get("minMuleVersion").getAsString();
            }
            MuleVersion muleVersion = new MuleVersion(minMuleVersion);
            this.validateMuleVersion(muleVersion);
            if (userCustomizedDescriptorJsonElement.getAsJsonObject().has("requiredProduct")) {
                requiredProduct = userCustomizedDescriptorJsonElement.getAsJsonObject().get("requiredProduct").getAsString();
                Preconditions.checkState((requiredProduct.equals(Product.MULE.name()) || requiredProduct.equals(Product.MULE_EE.name()) ? 1 : 0) != 0, (String)String.format("%s is invalid, value is %s and valid values are (%s, %s)", "requiredProduct", requiredProduct, Product.MULE.name(), Product.MULE_EE.name()));
            }
        }
        Preconditions.checkState((minMuleVersion != null ? 1 : 0) != 0, (String)"Unable to resolve the Extension minMuleVersion");
        targetDescriptorJsonElement.getAsJsonObject().addProperty("minMuleVersion", minMuleVersion);
        targetDescriptorJsonElement.getAsJsonObject().addProperty("requiredProduct", requiredProduct);
        try {
            targetDescriptorPath.getParent().toFile().mkdirs();
            if (Files.exists(targetDescriptorPath, new LinkOption[0])) {
                Files.delete(targetDescriptorPath);
            }
            Files.write(targetDescriptorPath, new GsonBuilder().setPrettyPrinting().create().toJson(targetDescriptorJsonElement).getBytes(), StandardOpenOption.CREATE);
        }
        catch (IOException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)e);
        }
    }

    private String resolveMinMuleVersion() {
        String muleVersion = (String)this.project.getProperties().get(MULE_VERSION_PROPERTY);
        Object minMuleVersion = this.project.getProperties().get(MIN_MULE_VERSION_PROPERTY);
        if (minMuleVersion == null) {
            return muleVersion;
        }
        MuleVersion muleVersionObject = new MuleVersion(muleVersion);
        MuleVersion minMuleVersionObject = new MuleVersion((String)minMuleVersion);
        com.google.common.base.Preconditions.checkArgument((boolean)minMuleVersionObject.atLeast(muleVersionObject), (Object)("Min mule version chosen (" + minMuleVersionObject + ") has to be at least equal or higher than the mule version (" + muleVersionObject + ")"));
        return (String)minMuleVersion;
    }

    private void validateMuleVersion(MuleVersion muleVersion) {
        if (!muleVersion.hasSuffix() || Boolean.parseBoolean(System.getProperty(SKIP_MULE_VERSION_SUFFIX_VALIDATION_PROPERTY, "false"))) {
            return;
        }
        com.google.common.base.Preconditions.checkArgument((boolean)SNAPSHOT_SUFFIX.equals(muleVersion.getSuffix()), (Object)"minMuleVersion cannot have suffix different from SNAPSHOT");
        com.google.common.base.Preconditions.checkArgument((boolean)this.project.getVersion().contains(SNAPSHOT_SUFFIX), (Object)("minMuleVersion declares an SNAPSHOT version, but the current project has version " + this.project.getVersion()));
    }

    private JsonElement getJsonElement(Path targetDescriptorPath) throws MojoExecutionException {
        byte[] descriptorContent;
        try {
            descriptorContent = Files.readAllBytes(targetDescriptorPath);
        }
        catch (IOException e) {
            throw new MojoExecutionException("failure opening file " + targetDescriptorPath.toFile().getAbsolutePath(), (Exception)e);
        }
        JsonParser parser = new JsonParser();
        return parser.parse(new String(descriptorContent));
    }

    private void createDescriptor(Path descriptorTargetPath) throws MojoExecutionException {
        String baseDirectory = this.project.getBuild().getOutputDirectory();
        File moduleFile = this.getModuleFile(baseDirectory);
        this.getLog().info((CharSequence)String.format("Generating [%s] descriptor for the <module> found in [%s]", "mule-artifact.json", moduleFile.getAbsolutePath()));
        Document doc = this.getModule(moduleFile).get();
        String name = doc.getDocumentElement().getAttribute(NAME_ATTRIBUTE);
        if (StringUtils.isBlank((CharSequence)name)) {
            throw new MojoExecutionException(String.format("There was an issue storing the dynamically generated descriptor file to [%s]", descriptorTargetPath));
        }
        String relativeModuleFileName = moduleFile.toURI().getPath().substring(new File(baseDirectory).toURI().getPath().length());
        this.createDescriptor(descriptorTargetPath, name, relativeModuleFileName, doc);
    }

    private void createDescriptor(Path descriptorPath, String name, String resourceXml, Document moduleDocument) throws MojoExecutionException {
        MulePluginModel.MulePluginModelBuilder mulePluginModelBuilder = (MulePluginModel.MulePluginModelBuilder)new MulePluginModel.MulePluginModelBuilder().setName(name);
        mulePluginModelBuilder.withBundleDescriptorLoader(new MuleArtifactLoaderDescriptor(MULE_LOADER_ID, Collections.emptyMap()));
        MuleArtifactLoaderDescriptorBuilder muleArtifactLoaderDescriptorBuilder = new MuleArtifactLoaderDescriptorBuilder().setId(MULE_LOADER_ID);
        Set<String> exportedResources = this.calculateExportedResources(name, moduleDocument);
        if (!exportedResources.isEmpty()) {
            muleArtifactLoaderDescriptorBuilder.addProperty("exportedResources", exportedResources);
        }
        mulePluginModelBuilder.withClassLoaderModelDescriptorLoader(muleArtifactLoaderDescriptorBuilder.build());
        mulePluginModelBuilder.withExtensionModelDescriber().setId(XML_BASED_EXTENSION_MODEL_LOADER).addProperty(RESOURCE_XML, (Object)resourceXml).addProperty(VALIDATE_XML, (Object)false).addProperty(RESOURCES_PATHS, exportedResources);
        Element moduleElement = moduleDocument.getDocumentElement();
        String vendor = moduleElement.getAttribute("vendor");
        String requiredEntitlement = moduleElement.getAttribute("requiredEntitlement");
        String allowsEvaluationLicense = moduleElement.getAttribute("allowsEvaluationLicense");
        String category = moduleElement.getAttribute(CATEGORY_ATTRIBUTE);
        mulePluginModelBuilder.setRequiredProduct(this.calculateProduct(name, category));
        if (!StringUtils.isBlank((CharSequence)requiredEntitlement)) {
            mulePluginModelBuilder.withLicenseModel().setRequiredEntitlement(requiredEntitlement).setProvider(StringUtils.isBlank((CharSequence)vendor) ? "Mulesoft" : vendor).setAllowsEvaluationLicense(StringUtils.isBlank((CharSequence)allowsEvaluationLicense) || "true".equals(allowsEvaluationLicense));
        }
        MulePluginModel build = mulePluginModelBuilder.build();
        String descriptor = new MulePluginModelJsonSerializer().serialize((AbstractMuleArtifactModel)build);
        try {
            descriptorPath.getParent().toFile().mkdirs();
            Files.write(descriptorPath, descriptor.getBytes(), StandardOpenOption.CREATE);
        }
        catch (IOException e) {
            throw new MojoExecutionException(String.format("There was an issue storing the dynamically generated descriptor file to [%s]", descriptorPath), (Exception)e);
        }
    }

    private Product calculateProduct(String name, String category) throws MojoExecutionException {
        Product product = StringUtils.isBlank((CharSequence)category) || Category.COMMUNITY.name().equals(category) ? Product.MULE : Product.MULE_EE;
        List eeArtifacts = this.project.getArtifacts().stream().filter(artifact -> artifact.getGroupId().startsWith(EE_MULESOFT_ARTIFACTS_GROUP_ID_PREFIX) && !"mule-plugin".equals(artifact.getClassifier())).collect(Collectors.toList());
        List mulePluginEEArtifacts = this.project.getArtifacts().stream().filter(artifact -> MulePluginArtifactLoaderUtils.readMulePluginModel(artifact).map(mulePluginModel -> mulePluginModel.getRequiredProduct().supports(Product.MULE_EE)).orElse(false)).collect(Collectors.toList());
        if (!eeArtifacts.isEmpty() || !mulePluginEEArtifacts.isEmpty()) {
            if (!product.equals((Object)Product.MULE)) {
                product = Product.MULE_EE;
            } else {
                StringBuilder sb = new StringBuilder("The current module states it's ").append(Category.COMMUNITY).append(" while it relies in EE components/EE Mule Plugins at runtime directly or indirectly (through transitive dependencies).");
                if (!eeArtifacts.isEmpty()) {
                    sb.append("\nFull list of EE components:\n").append(String.join((CharSequence)",\n", eeArtifacts.stream().map(Object::toString).collect(Collectors.toSet())));
                }
                if (!mulePluginEEArtifacts.isEmpty()) {
                    sb.append("\nFull list of EE Mule Plugins:\n").append(String.join((CharSequence)",\n", mulePluginEEArtifacts.stream().map(Object::toString).collect(Collectors.toSet())));
                }
                String templateModuleElement = "<module name=\"" + name + "\" category=\"%s\" .../>";
                sb.append("\nUpdate, or add, the 'category' attribute of the module element to any of the following:\n").append(String.format(templateModuleElement, Category.SELECT)).append(",\n").append(String.format(templateModuleElement, Category.PREMIUM)).append(",\n").append(String.format(templateModuleElement, Category.CERTIFIED)).append(".").append("\nFor more details please go to https://docs.mulesoft.com/mule-sdk/v/1.1/license");
                throw new MojoExecutionException(sb.toString());
            }
        }
        return product;
    }

    private Set<String> calculateExportedResources(String extensionName, Document moduleDocument) throws MojoExecutionException {
        HashSet<String> result = new HashSet<String>();
        Optional<String> prefix = Optional.ofNullable(moduleDocument.getDocumentElement().getAttribute(PREFIX_ATTRIBUTE));
        XmlDslModel xmlLanguageModel = XmlModelUtils.createXmlLanguageModel(prefix, Optional.empty(), (String)extensionName, null);
        String sanitizedName = this.sanitizeName(xmlLanguageModel.getPrefix());
        Path targetResourceFolder = Paths.get(this.project.getBuild().getOutputDirectory(), sanitizedName);
        Set<String> processedResources = this.findFilesFrom(targetResourceFolder, sanitizedName);
        for (Resource resource : this.project.getResources()) {
            Set resourcesToExport = this.calculateExportedResources(resource, processedResources, sanitizedName).stream().map(MulePluginArtifactLoaderUtils::toZipPath).collect(Collectors.toSet());
            result.addAll(resourcesToExport);
        }
        return result;
    }

    private String sanitizeName(String name) {
        char[] nameArray = name.toCharArray();
        for (int i = 0; i < nameArray.length; ++i) {
            if (Character.isJavaIdentifierPart(nameArray[i])) continue;
            nameArray[i] = 95;
        }
        return (!Character.isJavaIdentifierStart(nameArray[0]) ? "_" : "") + new String(nameArray);
    }

    private Set<String> calculateExportedResources(Resource resource, Set<String> processedResources, String prefixFolder) throws MojoExecutionException {
        HashSet<String> result = new HashSet<String>();
        Path resouceWithExportFolder = Paths.get(resource.getDirectory(), prefixFolder);
        Set<String> resourceFiles = this.findFilesFrom(resouceWithExportFolder, prefixFolder);
        if (resourceFiles.isEmpty()) {
            this.getLog().info((CharSequence)String.format("No resources to export in [%s] (only resources under [%s] folder will be automatically exported)", resource.getDirectory(), prefixFolder));
        } else {
            this.getLog().debug((CharSequence)String.format("Looking for resources under [%s] to export", resouceWithExportFolder));
            HashSet notExportables = new HashSet();
            HashSet exportables = new HashSet();
            resourceFiles.stream().filter(processedResources::contains).forEach(path -> {
                if (!path.toLowerCase().contains(INTERNAL_FOLDER)) {
                    exportables.add(path);
                } else {
                    notExportables.add(path);
                }
            });
            if (!notExportables.isEmpty()) {
                this.getLog().info((CharSequence)String.format("The following files under [%s] won't be exported as they are inside folders that contain the [%s] value. Those files are: [%s]", resouceWithExportFolder, INTERNAL_FOLDER, String.join((CharSequence)", ", notExportables)));
            }
            this.getLog().info((CharSequence)String.format("Found [%s] resource%s to export under [%s]", exportables.size(), exportables.size() > 1 ? "s" : "", resouceWithExportFolder));
            result.addAll(exportables);
        }
        return result;
    }

    private Set<String> findFilesFrom(Path originPath, String prefixFolder) throws MojoExecutionException {
        HashSet<String> result = new HashSet<String>();
        if (Files.exists(originPath, new LinkOption[0])) {
            try {
                Files.walk(originPath, new FileVisitOption[0]).filter(path -> Files.isRegularFile(path, new LinkOption[0])).map(file -> prefixFolder + File.separator + originPath.relativize((Path)file).toString()).forEach(result::add);
            }
            catch (IOException e) {
                throw new MojoExecutionException(String.format("There was an issue looking for resources in the folder [%s]", originPath), (Exception)e);
            }
        }
        return result;
    }

    private File getModuleFile(String baseDirectory) throws MojoExecutionException {
        List modulesFiles = FileUtils.listFiles((File)new File(baseDirectory), (IOFileFilter)new FileFileFilter(){

            public boolean accept(File file) {
                return file.getName().startsWith(ExtensionDescriptorMojo.PREFIX_SMART_CONNECTOR_NAME) && file.getName().endsWith(ExtensionDescriptorMojo.SUFFIX_SMART_CONNECTOR_NAME);
            }
        }, (IOFileFilter)TrueFileFilter.INSTANCE).stream().filter(file -> this.getModule((File)file).isPresent()).collect(Collectors.toList());
        if (modulesFiles.size() > 1) {
            String xmlModules = NativeArray.join((Object)"\n,", modulesFiles.stream().map(File::getAbsolutePath).collect(Collectors.toList()));
            throw new MojoExecutionException(String.format("There are several XML files that have a <module> root element, when there must be only one. Files with <module> as root element are: [%s]", xmlModules));
        }
        if (modulesFiles.isEmpty()) {
            throw new MojoExecutionException(String.format("There's no XML files that has a <module> root element, thus is impossible to auto generate a [%s] descriptor file. The file must start with [%s] and end with [%s], such as [%s]", "mule-artifact.json", PREFIX_SMART_CONNECTOR_NAME, SUFFIX_SMART_CONNECTOR_NAME, "module-foo.xml"));
        }
        return (File)modulesFiles.get(0);
    }

    private Optional<Document> getModule(File file) {
        Optional<Document> result = Optional.empty();
        DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
            Document doc = dBuilder.parse(file);
            if (doc.getDocumentElement().getNodeName().equals(MODULE_ROOT_ELEMENT)) {
                result = Optional.of(doc);
            }
        }
        catch (IOException | ParserConfigurationException | SAXException exception) {
            // empty catch block
        }
        return result;
    }
}

