/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.maven;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.net.MalformedURLException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.apache.commons.io.FileUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.ArtifactUtils;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.descriptor.PluginDescriptor;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProjectHelper;
import org.mule.extension.maven.loader.MavenProjectExtensionModelLoader;
import org.mule.extension.maven.loader.MulePluginJsonDescriberLoader;
import org.mule.plugin.maven.AbstractMuleMojo;
import org.mule.runtime.api.deployment.meta.MulePluginModel;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.extension.api.persistence.ExtensionModelJsonSerializer;

@Mojo(name="extension-model", defaultPhase=LifecyclePhase.PACKAGE, requiresDependencyResolution=ResolutionScope.TEST, threadSafe=true)
public class ExtensionModelMojo
extends AbstractMuleMojo {
    public static final String TEMPORAL_EXTENSION_MODEL_JSON = "temporal-extension-model.json";
    public static final String SKIP_EXTENSION_MODEL_VALIDATION = "skipExtensionModelValidation";
    private static final String ORG_MULE_RUNTIME = "org.mule.runtime";
    private static final String COM_MULESOFT_MULE_RUNTIME_MODULES = "com.mulesoft.mule.runtime.modules";
    private static final String JAR = "jar";
    @Parameter(defaultValue="${session}", readonly=true, required=true)
    private MavenSession session;
    @Inject
    private MavenProjectHelper projectHelper;
    @Parameter(defaultValue="${plugin}", readonly=true)
    private PluginDescriptor pluginDescriptor;
    @Parameter(defaultValue="false", property="skipExtensionModelValidation")
    private Boolean skipExtensionModelValidation;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.disableExtensionModelFileGeneration.booleanValue()) {
            this.getLog().info((CharSequence)"Extension Model generation skipped.");
            return;
        }
        if (this.skipExtensionModelValidation.booleanValue()) {
            this.getLog().warn((CharSequence)"Extension Model generation will be done by omitting validations, thus it wil not validate it's syntactically correct (BE SURE TO TEST THE CONNECTOR).");
        }
        MulePluginModel mulePluginDescriber = MulePluginJsonDescriberLoader.loadMulePluginDescriber(this.buildDirectory);
        MavenProjectExtensionModelLoader extensionModelLoader = new MavenProjectExtensionModelLoader(this.getLog());
        this.enrichPluginClassLoader();
        ExtensionModel extensionModel = extensionModelLoader.loadExtension(this.project, this.session, this.skipExtensionModelValidation == false);
        this.addSupportedJavaVersionstoMuleArtifactJson(extensionModel);
        String serializedExtensionModel = new ExtensionModelJsonSerializer(true).serialize(extensionModel);
        File generatedExtensionModelFile = new File(this.buildDirectory, TEMPORAL_EXTENSION_MODEL_JSON);
        try (PrintWriter out = new PrintWriter(generatedExtensionModelFile);){
            out.println(serializedExtensionModel);
        }
        catch (FileNotFoundException e) {
            throw new MojoFailureException(String.format("Failure while saving the serialized ExtensionModel to the file [%s]", generatedExtensionModelFile.getAbsolutePath()));
        }
        this.projectHelper.attachArtifact(this.project, "json", "extension-model-" + mulePluginDescriber.getMinMuleVersion(), generatedExtensionModelFile);
    }

    private void enrichPluginClassLoader() throws MojoExecutionException {
        List pluginRuntimeLibraries = this.pluginDescriptor.getArtifacts().stream().filter(this::isRuntimeArtifact).map(ArtifactUtils::versionlessKey).collect(Collectors.toList());
        this.getLog().debug((CharSequence)("pluginRuntimeLibraries: " + String.valueOf(pluginRuntimeLibraries)));
        List runtimeProvidedLibraries = this.project.getArtifacts().stream().filter(artifact -> artifact.getScope().equals("provided")).filter(this::isRuntimeArtifact).filter(artifact -> artifact.getType().equals(JAR)).filter(artifact -> !this.pluginDescriptor.getArtifacts().contains(artifact)).filter(artifact -> !pluginRuntimeLibraries.contains(ArtifactUtils.versionlessKey((Artifact)artifact))).collect(Collectors.toList());
        this.getLog().debug((CharSequence)("runtimeProvidedLibraries: " + String.valueOf(runtimeProvidedLibraries)));
        for (Artifact runtimeProvidedLibrary : runtimeProvidedLibraries) {
            this.getLog().info((CharSequence)String.format("Adding URL to plugin class loader for provided Mule Runtime library: %s", runtimeProvidedLibrary));
            try {
                this.pluginDescriptor.getClassRealm().addURL(runtimeProvidedLibrary.getFile().toURI().toURL());
            }
            catch (MalformedURLException e) {
                throw new MojoExecutionException("Error while getting Mule Runtime provided library from project", (Exception)e);
            }
        }
    }

    private boolean isRuntimeArtifact(Artifact artifact) {
        return artifact.getGroupId().equals(ORG_MULE_RUNTIME) || artifact.getGroupId().equals(COM_MULESOFT_MULE_RUNTIME_MODULES);
    }

    private void addSupportedJavaVersionstoMuleArtifactJson(ExtensionModel extensionModel) throws MojoFailureException {
        Path targetDescriptorPath = Paths.get(this.project.getBuild().getOutputDirectory(), "META-INF", "mule-artifact", "mule-artifact.json");
        try {
            JsonElement original = JsonParser.parseReader((Reader)new FileReader(targetDescriptorPath.toFile()));
            JsonArray supportedJavaVersionsJson = new JsonArray();
            extensionModel.getSupportedJavaVersions().forEach(arg_0 -> ((JsonArray)supportedJavaVersionsJson).add(arg_0));
            ((JsonObject)original).add("supportedJavaVersions", (JsonElement)supportedJavaVersionsJson);
            FileUtils.write((File)targetDescriptorPath.toFile(), (CharSequence)original.toString(), (Charset)StandardCharsets.UTF_8);
        }
        catch (JsonParseException | IOException e) {
            throw new MojoFailureException(e);
        }
    }
}

