/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.maven;

import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.vdurmont.semver4j.Semver;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.jar.Manifest;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.mule.extension.maven.util.MulePluginArtifactLoaderUtils;
import org.mule.plugin.maven.AbstractMuleMojo;
import org.mule.runtime.api.deployment.meta.AbstractMuleArtifactModel;
import org.mule.runtime.module.artifact.api.descriptor.BundleDescriptor;
import org.mule.runtime.module.embedded.internal.jvm.JvmVersionIntervalUnion;

@Mojo(name="extension-validate", defaultPhase=LifecyclePhase.VERIFY, threadSafe=true, requiresDependencyResolution=ResolutionScope.COMPILE)
public class ExtensionValidationMojo
extends AbstractMuleMojo {
    private static final String TARGET_JAVA_VERSION_MF_ATTR = "Target-Java-Release-Version";
    private static final Semver JAVA_8_VERSION = new Semver("1.8", Semver.SemverType.LOOSE);
    private static final Pattern MAJOR_MINOR_EXTRACT = Pattern.compile("(\\d+\\.\\d+).\\d+(?:-SNAPSHOT)?");
    private static final Map<String, String> MULE_RUNTIME_SUPPORTED_JAVA_VERSIONS;
    private static final String MULE_RUNTIME_SUPPORT_JAVA_VERSIONS_PROPERTIES_PATH = "/muleRuntimeSupportedJavaVersions.properties";
    @Parameter(required=true, defaultValue="${project.build.outputDirectory}")
    protected File buildOutputDirectory;

    public void execute() throws MojoExecutionException, MojoFailureException {
        String extensionModelLoaderDescriptorId = this.getExtensionModelLoaderDescriptorId();
        if ("java".equals(extensionModelLoaderDescriptorId)) {
            this.executeJavaExtensionValidations();
        } else {
            this.getLog().debug((CharSequence)("No java validations for `" + extensionModelLoaderDescriptorId + "` extension"));
        }
    }

    private void executeJavaExtensionValidations() throws MojoFailureException, MojoExecutionException {
        this.getLog().debug((CharSequence)"Validating `module-info.java`...");
        this.validateModuleInfo();
        String targetJavaVersion = this.getTargetJavaVersion();
        this.getLog().debug((CharSequence)"Validating target Java version against minMuleVerision...");
        this.validateTargetJavaVersionAgainstMinMuleVersion(targetJavaVersion);
        if (this.disableExtensionModelFileGeneration.booleanValue()) {
            this.getLog().info((CharSequence)"Extension Model generation skipped.");
        } else {
            this.getLog().debug((CharSequence)"Validating target Java version against @JavaVersionSupport...");
            this.validateTargetJavaVersionAgainstJavaVersionSupportAnn(targetJavaVersion);
        }
    }

    private String getExtensionModelLoaderDescriptorId() throws MojoExecutionException {
        String string;
        FileInputStream majis = new FileInputStream(new File(this.buildOutputDirectory, "META-INF/mule-artifact/mule-artifact.json"));
        try {
            JsonElement jsonReader = JsonParser.parseReader((Reader)new InputStreamReader(majis));
            string = jsonReader.getAsJsonObject().get("extensionModelLoaderDescriptor").getAsJsonObject().get("id").getAsString();
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((InputStream)majis).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new MojoExecutionException((Throwable)e);
            }
        }
        ((InputStream)majis).close();
        return string;
    }

    private void validateModuleInfo() throws MojoFailureException {
        if (Stream.of(this.buildOutputDirectory.list()).anyMatch(f -> f.equals("module-info.class"))) {
            throw new MojoFailureException("JPMS is not supported for Mule extensions. `module-info.java` found in the project.");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String getTargetJavaVersion() throws MojoExecutionException {
        File manifestFile = new File(this.buildDirectory, "mule-packager/src/main/resources/META-INF/MANIFEST.MF");
        Manifest manifest = new Manifest();
        try (FileInputStream mis = new FileInputStream(manifestFile);){
            manifest.read(mis);
            String targetJavaReleaseVersion = manifest.getMainAttributes().getValue(TARGET_JAVA_VERSION_MF_ATTR);
            if ("8".equals(targetJavaReleaseVersion)) {
                String string = "1.8";
                return string;
            }
            String string = targetJavaReleaseVersion;
            return string;
        }
        catch (IOException e) {
            throw new MojoExecutionException((Throwable)e);
        }
    }

    private void validateTargetJavaVersionAgainstMinMuleVersion(String targetJavaVersion) throws MojoFailureException {
        String minMuleversion = this.project.getAttachedArtifacts().stream().filter(artifact -> artifact.getClassifier().equals(BundleDescriptor.MULE_PLUGIN_CLASSIFIER)).map(MulePluginArtifactLoaderUtils::readMulePluginModel).filter(Optional::isPresent).map(Optional::get).map(AbstractMuleArtifactModel::getMinMuleVersion).findAny().get();
        String runtimeSupportedJavaVersions = this.getRuntimeSupportedJavaVersions(minMuleversion);
        Objects.requireNonNull(runtimeSupportedJavaVersions, "No `runtimeSupportedJavaVersions` for Mule version `" + minMuleversion + "` in `mule-extensions-maven-plugin/mule-extensions-maven-plugin/src/main/resources/muleRuntimeSupportedJavaVersions.properties`");
        JvmVersionIntervalUnion jvmVersionIntervalUnion = JvmVersionIntervalUnion.parse((String)runtimeSupportedJavaVersions);
        if (!jvmVersionIntervalUnion.includes(targetJavaVersion)) {
            throw new MojoFailureException("Target java version (" + targetJavaVersion + ") is not supported by the declared minMuleVersion (" + minMuleversion + ": " + runtimeSupportedJavaVersions + ")");
        }
    }

    private String getRuntimeSupportedJavaVersions(String minMuleversion) throws MojoFailureException {
        Matcher matcher = MAJOR_MINOR_EXTRACT.matcher(minMuleversion);
        if (matcher.find()) {
            return MULE_RUNTIME_SUPPORTED_JAVA_VERSIONS.get(matcher.group(1));
        }
        throw new MojoFailureException("No java version supportability for mule version `" + minMuleversion + "`");
    }

    private void validateTargetJavaVersionAgainstJavaVersionSupportAnn(String targetJavaVersion) throws MojoFailureException, MojoExecutionException {
        try (FileInputStream emis = new FileInputStream(new File(this.buildDirectory, "temporal-extension-model.json"));){
            JsonElement jsonReader = JsonParser.parseReader((Reader)new InputStreamReader(emis));
            Semver lowerSupportedJavaVersion = jsonReader.getAsJsonObject().get("supportedJavaVersions").getAsJsonArray().asList().stream().map(JsonElement::getAsString).map(v -> new Semver(v, Semver.SemverType.LOOSE)).sorted().findFirst().orElse(JAVA_8_VERSION);
            if (new Semver(targetJavaVersion, Semver.SemverType.LOOSE).isGreaterThan(lowerSupportedJavaVersion)) {
                throw new MojoFailureException("Target java version (" + targetJavaVersion + ") is not supported by the lowest declared @JavaVersionSupport (" + String.valueOf(lowerSupportedJavaVersion) + ")");
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException((Throwable)e);
        }
    }

    static {
        Properties muleRuntimesupportedJavaVersions = new Properties();
        try {
            muleRuntimesupportedJavaVersions.load(ExtensionValidationMojo.class.getResourceAsStream(MULE_RUNTIME_SUPPORT_JAVA_VERSIONS_PROPERTIES_PATH));
        }
        catch (IOException e2) {
            throw new RuntimeException(e2.toString());
        }
        MULE_RUNTIME_SUPPORTED_JAVA_VERSIONS = Collections.unmodifiableMap(muleRuntimesupportedJavaVersions.entrySet().stream().collect(Collectors.toMap(e -> e.getKey().toString(), e -> e.getValue().toString())));
    }
}

