/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.maven;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.util.List;
import javax.inject.Inject;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.resolution.ArtifactRequest;
import org.eclipse.aether.resolution.ArtifactResolutionException;
import org.mule.extension.maven.loader.MavenProjectExtensionModelLoader;
import org.mule.plugin.maven.AbstractMuleMojo;
import org.mule.runtime.api.artifact.ArtifactType;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.extension.api.persistence.ExtensionModelJsonSerializer;

@Mojo(name="extension-model-load", threadSafe=true)
public class ExtensionModelLoadMojo
extends AbstractMuleMojo {
    @Parameter(defaultValue="${session}", readonly=true, required=true)
    private MavenSession session;
    @Inject
    protected RepositorySystem repositorySystem;
    @Parameter(defaultValue="${repositorySystemSession}", readonly=true)
    protected RepositorySystemSession repositorySystemSession;
    @Parameter(defaultValue="${project.remoteProjectRepositories}", readonly=true)
    private List<RemoteRepository> remoteRepositories;
    @Parameter
    private String outputFileName;
    @Parameter(defaultValue="${project.build.directory}")
    private File outputDirectory;
    @Parameter(required=true)
    private String groupId;
    @Parameter(required=true)
    private String artifactId;
    @Parameter(required=true)
    private String version;

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.getLog().info((CharSequence)String.format("Loading ExtensionModel for artifact [%s:%s:%s]", this.groupId, this.artifactId, this.version));
        org.apache.maven.artifact.Artifact artifact = this.resolveMulePluginArtifact();
        MavenProjectExtensionModelLoader extensionModelLoader = new MavenProjectExtensionModelLoader(this.getLog());
        ExtensionModel extensionModel = extensionModelLoader.loadExtension(artifact, this.session, true);
        String serializedExtensionModel = new ExtensionModelJsonSerializer(true).serialize(extensionModel);
        this.outputDirectory.mkdirs();
        File outputFile = new File(this.outputDirectory, this.outputFileName(artifact));
        try (PrintWriter out = new PrintWriter(outputFile);){
            out.println(serializedExtensionModel);
        }
        catch (FileNotFoundException e) {
            throw new MojoFailureException(String.format("Failure while saving the serialized ExtensionModel to the file [%s]", outputFile.getAbsolutePath()), (Throwable)e);
        }
    }

    private String outputFileName(org.apache.maven.artifact.Artifact artifact) {
        if (this.outputFileName != null) {
            return this.outputFileName;
        }
        return artifact.getArtifactId() + "-" + artifact.getVersion() + "-extension-model.json";
    }

    private org.apache.maven.artifact.Artifact resolveMulePluginArtifact() throws MojoExecutionException {
        DefaultArtifact aetherArtifact = new DefaultArtifact(this.groupId, this.artifactId, ArtifactType.PLUGIN.getMavenArtifactClassifier(), "jar", this.version);
        try {
            ArtifactRequest artifactRequest = new ArtifactRequest((Artifact)aetherArtifact, this.remoteRepositories, null);
            Artifact artifact = this.repositorySystem.resolveArtifact(this.repositorySystemSession, artifactRequest).getArtifact();
            return new org.apache.maven.artifact.DefaultArtifact(artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion(), null, artifact.getExtension(), artifact.getClassifier(), null);
        }
        catch (ArtifactResolutionException e) {
            throw new MojoExecutionException(String.format("Error while resolving Mule Plugin artifact: [%s]", aetherArtifact), (Exception)((Object)e));
        }
    }
}

