/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.maven.documentation.types;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.mule.extension.maven.documentation.types.ObjectTypeUtils;
import org.mule.metadata.api.model.ArrayType;
import org.mule.metadata.api.model.ObjectType;
import org.mule.metadata.api.model.UnionType;
import org.mule.metadata.api.visitor.MetadataTypeVisitor;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.HasOutputModel;
import org.mule.runtime.api.meta.model.operation.HasOperationModels;
import org.mule.runtime.api.meta.model.operation.OperationModel;
import org.mule.runtime.api.meta.model.parameter.ParameterGroupModel;
import org.mule.runtime.api.meta.model.parameter.ParameterModel;
import org.mule.runtime.api.meta.model.parameter.ParameterizedModel;
import org.mule.runtime.api.meta.model.source.HasSourceModels;
import org.mule.runtime.api.meta.model.source.SourceModel;
import org.mule.runtime.api.meta.model.util.ExtensionWalker;

class TypeRegister {
    private final Map<String, ObjectType> types = new LinkedHashMap<String, ObjectType>();
    private final Map<String, List<String>> subtypesIdMap = new LinkedHashMap<String, List<String>>();

    TypeRegister(ExtensionModel extension) {
        this.fillSubtypes(extension);
        this.fillExposedTypes(extension);
    }

    private void fillSubtypes(ExtensionModel extension) {
        extension.getSubTypes().forEach(subtype -> {
            List<String> subtypesIds = subtype.getSubTypes().stream().filter(o -> ObjectTypeUtils.getObjectTypeId(o).isPresent()).map(o -> ObjectTypeUtils.getObjectTypeId(o).get()).toList();
            ObjectTypeUtils.getObjectTypeId(subtype.getBaseType()).ifPresent(baseTypeId -> this.subtypesIdMap.put((String)baseTypeId, subtypesIds));
        });
    }

    private void fillExposedTypes(ExtensionModel extension) {
        final RegisterVisitor visitor = new RegisterVisitor();
        new ExtensionWalker(){

            protected void onSource(HasSourceModels owner, SourceModel source) {
                this.visitComponent((HasOutputModel)source);
            }

            protected void onOperation(HasOperationModels owner, OperationModel operation) {
                this.visitComponent((HasOutputModel)operation);
            }

            private void visitComponent(HasOutputModel component) {
                component.getOutput().getType().accept(visitor);
                component.getOutputAttributes().getType().accept(visitor);
            }

            protected void onParameter(ParameterizedModel owner, ParameterGroupModel groupModel, ParameterModel parameter) {
                parameter.getType().accept(visitor);
            }
        }.walk(extension);
        extension.getSubTypes().forEach(subtype -> subtype.getSubTypes().forEach(t -> t.accept(visitor)));
    }

    Map<String, ObjectType> getTypes() {
        return Collections.unmodifiableMap(this.types);
    }

    Map<String, List<String>> getSubtypes() {
        return Collections.unmodifiableMap(this.subtypesIdMap);
    }

    private class RegisterVisitor
    extends MetadataTypeVisitor {
        private RegisterVisitor() {
        }

        public void visitArrayType(ArrayType arrayType) {
            arrayType.getType().accept((MetadataTypeVisitor)this);
        }

        public void visitObject(ObjectType object) {
            if (ObjectTypeUtils.isMessage(object)) {
                object.getFields().forEach(f -> f.getValue().accept((MetadataTypeVisitor)this));
            } else {
                ObjectTypeUtils.getObjectTypeId(object).ifPresent(id -> {
                    if (!TypeRegister.this.types.containsKey(id) && !TypeRegister.this.subtypesIdMap.containsKey(id)) {
                        this.addType(object);
                        object.getFields().forEach(f -> f.getValue().accept((MetadataTypeVisitor)this));
                    }
                });
            }
        }

        private void addType(ObjectType type) {
            ObjectTypeUtils.getObjectTypeId(type).ifPresent(id -> {
                if (!TypeRegister.this.subtypesIdMap.containsKey(id) && !type.getFields().isEmpty()) {
                    TypeRegister.this.types.put((String)id, type);
                }
            });
        }

        public void visitUnion(UnionType unionType) {
            unionType.getTypes().forEach(t -> t.accept((MetadataTypeVisitor)this));
        }
    }
}

