/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.maven;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.net.MalformedURLException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import javax.inject.Inject;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.ArtifactUtils;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.descriptor.PluginDescriptor;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProjectHelper;
import org.mule.extension.maven.loader.MavenProjectExtensionModelLoader;
import org.mule.extension.maven.loader.MulePluginJsonDescriberLoader;
import org.mule.plugin.maven.AbstractMuleMojo;
import org.mule.runtime.api.deployment.meta.MulePluginModel;
import org.mule.runtime.api.meta.MuleVersion;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.extension.api.persistence.ExtensionModelJsonSerializer;

@Mojo(name="extension-model", defaultPhase=LifecyclePhase.PACKAGE, requiresDependencyResolution=ResolutionScope.TEST, threadSafe=true)
public class ExtensionModelMojo
extends AbstractMuleMojo {
    public static final String TEMPORAL_EXTENSION_MODEL_JSON = "temporal-extension-model.json";
    public static final String SKIP_EXTENSION_MODEL_VALIDATION = "skipExtensionModelValidation";
    private static final String ORG_MULE_RUNTIME = "org.mule.runtime";
    private static final String COM_MULESOFT_MULE_RUNTIME_MODULES = "com.mulesoft.mule.runtime.modules";
    private static final String JAR = "jar";
    @Parameter(defaultValue="${session}", readonly=true, required=true)
    private MavenSession session;
    @Inject
    private MavenProjectHelper projectHelper;
    @Parameter(defaultValue="${plugin}", readonly=true)
    private PluginDescriptor pluginDescriptor;
    @Parameter(defaultValue="false", property="skipExtensionModelValidation")
    private boolean skipExtensionModelValidation;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.disableExtensionModelFileGeneration) {
            this.getLog().info((CharSequence)"Extension Model generation skipped.");
            this.addMinMuleVersionToMuleArtifactJson(() -> new MuleVersion((String)this.project.getProperties().get("min.mule.version")));
            return;
        }
        if (this.skipExtensionModelValidation) {
            this.getLog().warn((CharSequence)"Extension Model generation will be done by omitting validations, thus it wil not validate it's syntactically correct (BE SURE TO TEST THE CONNECTOR).");
        }
        MulePluginModel mulePluginDescriber = MulePluginJsonDescriberLoader.loadMulePluginDescriber(this.buildDirectory);
        MavenProjectExtensionModelLoader extensionModelLoader = new MavenProjectExtensionModelLoader(this.getLog());
        this.enrichPluginClassLoader();
        ExtensionModel extensionModel = extensionModelLoader.loadExtension(this.project, this.session, !this.skipExtensionModelValidation);
        this.addToMuleArtifactJson(extensionModel);
        String serializedExtensionModel = new ExtensionModelJsonSerializer(true).serialize(extensionModel);
        File generatedExtensionModelFile = new File(this.buildDirectory, TEMPORAL_EXTENSION_MODEL_JSON);
        try (PrintWriter out = new PrintWriter(generatedExtensionModelFile);){
            out.println(serializedExtensionModel);
        }
        catch (FileNotFoundException e) {
            throw new MojoFailureException(String.format("Failure while saving the serialized ExtensionModel to the file [%s]", generatedExtensionModelFile.getAbsolutePath()));
        }
        this.projectHelper.attachArtifact(this.project, "json", "extension-model-" + mulePluginDescriber.getMinMuleVersion(), generatedExtensionModelFile);
    }

    void addToMuleArtifactJson(ExtensionModel extensionModel) throws MojoFailureException {
        this.addMinMuleVersionToMuleArtifactJson(() -> this.resolveMinMuleVersion(extensionModel));
        this.addSupportedJavaVersionsToMuleArtifactJson(extensionModel);
    }

    private void enrichPluginClassLoader() throws MojoExecutionException {
        List<String> pluginRuntimeLibraries = this.pluginDescriptor.getArtifacts().stream().filter(this::isRuntimeArtifact).map(ArtifactUtils::versionlessKey).toList();
        this.getLog().debug((CharSequence)("pluginRuntimeLibraries: " + String.valueOf(pluginRuntimeLibraries)));
        List<Artifact> runtimeProvidedLibraries = this.project.getArtifacts().stream().filter(artifact -> artifact.getScope().equals("provided")).filter(this::isRuntimeArtifact).filter(artifact -> artifact.getType().equals(JAR)).filter(artifact -> !this.pluginDescriptor.getArtifacts().contains(artifact)).filter(artifact -> !pluginRuntimeLibraries.contains(ArtifactUtils.versionlessKey((Artifact)artifact))).toList();
        this.getLog().debug((CharSequence)("runtimeProvidedLibraries: " + String.valueOf(runtimeProvidedLibraries)));
        for (Artifact runtimeProvidedLibrary : runtimeProvidedLibraries) {
            this.getLog().info((CharSequence)String.format("Adding URL to plugin class loader for provided Mule Runtime library: %s", runtimeProvidedLibrary));
            try {
                this.pluginDescriptor.getClassRealm().addURL(runtimeProvidedLibrary.getFile().toURI().toURL());
            }
            catch (MalformedURLException e) {
                throw new MojoExecutionException("Error while getting Mule Runtime provided library from project", (Exception)e);
            }
        }
    }

    private boolean isRuntimeArtifact(Artifact artifact) {
        return artifact.getGroupId().equals(ORG_MULE_RUNTIME) || artifact.getGroupId().equals(COM_MULESOFT_MULE_RUNTIME_MODULES);
    }

    private JsonElement readMuleArtifactJson() throws JsonParseException, IOException {
        Path targetDescriptorPath = Paths.get(this.project.getBuild().getOutputDirectory(), "META-INF", "mule-artifact", "mule-artifact.json");
        return JsonParser.parseReader((Reader)Files.newBufferedReader(targetDescriptorPath, StandardCharsets.UTF_8));
    }

    private void addMinMuleVersionToMuleArtifactJson(Supplier<MuleVersion> muleVersion) throws MojoFailureException {
        Path targetDescriptorPath = Paths.get(this.project.getBuild().getOutputDirectory(), "META-INF", "mule-artifact", "mule-artifact.json");
        try {
            JsonElement original = this.readMuleArtifactJson();
            if (!((JsonObject)original).has("minMuleVersion")) {
                MuleVersion minMuleVersion = muleVersion.get();
                if (minMuleVersion.getRevision() == -1) {
                    minMuleVersion = new MuleVersion(minMuleVersion.getMajor() + "." + minMuleVersion.getMinor() + ".0");
                }
                ((JsonObject)original).addProperty("minMuleVersion", minMuleVersion.toString());
            } else {
                this.getLog().warn((CharSequence)"minMuleVersion set in mule-artifact.json, ignoring extension or pom property.");
            }
            Files.writeString(targetDescriptorPath, (CharSequence)original.toString(), StandardCharsets.UTF_8, new OpenOption[0]);
        }
        catch (JsonParseException | IOException e) {
            throw new MojoFailureException(e);
        }
    }

    private MuleVersion resolveMinMuleVersion(ExtensionModel extensionModel) {
        String pomMmv = (String)this.project.getProperties().get("min.mule.version");
        Optional extModelMmv = extensionModel.getMinMuleVersion();
        if (pomMmv == null && extModelMmv.isEmpty()) {
            this.getLog().warn((CharSequence)"No minMuleVersion determined for the extension or configured in the pom, defaulting to 4.1.1.");
            return new MuleVersion("4.1.1");
        }
        if (pomMmv == null) {
            return (MuleVersion)extModelMmv.orElseThrow();
        }
        if (extModelMmv.isEmpty()) {
            return new MuleVersion(pomMmv);
        }
        MuleVersion mmv = (MuleVersion)extModelMmv.orElseThrow();
        MuleVersion actualMmv = null;
        if (mmv.newerThan(pomMmv)) {
            this.getLog().warn((CharSequence)"`%s` property in pom.xml declares a lower version than the one actually required by the extension (%s).".formatted("min.mule.version", mmv));
            actualMmv = mmv;
        } else {
            actualMmv = new MuleVersion(pomMmv);
        }
        return actualMmv;
    }

    private void addSupportedJavaVersionsToMuleArtifactJson(ExtensionModel extensionModel) throws MojoFailureException {
        Path targetDescriptorPath = Paths.get(this.project.getBuild().getOutputDirectory(), "META-INF", "mule-artifact", "mule-artifact.json");
        try {
            JsonElement original = this.readMuleArtifactJson();
            JsonArray supportedJavaVersionsJson = new JsonArray();
            extensionModel.getSupportedJavaVersions().forEach(arg_0 -> ((JsonArray)supportedJavaVersionsJson).add(arg_0));
            ((JsonObject)original).add("supportedJavaVersions", (JsonElement)supportedJavaVersionsJson);
            Files.writeString(targetDescriptorPath, (CharSequence)original.toString(), StandardCharsets.UTF_8, new OpenOption[0]);
        }
        catch (JsonParseException | IOException e) {
            throw new MojoFailureException(e);
        }
    }
}

