/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.maven;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintWriter;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProjectHelper;
import org.apache.maven.project.ProjectDependenciesResolver;
import org.mule.extension.maven.loader.MavenProjectExtensionModelLoader;
import org.mule.extension.maven.loader.MulePluginJsonDescriberLoader;
import org.mule.plugin.maven.AbstractMuleMojo;
import org.mule.runtime.api.deployment.meta.MuleArtifactLoaderDescriptor;
import org.mule.runtime.api.deployment.meta.MulePluginModel;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.extension.api.persistence.ExtensionModelJsonSerializer;

@Mojo(name="extension-model", defaultPhase=LifecyclePhase.PACKAGE, requiresDependencyResolution=ResolutionScope.TEST, threadSafe=true)
public class ExtensionModelMojo
extends AbstractMuleMojo {
    public static final String TEMPORAL_EXTENSION_MODEL_JSON = "temporal-extension-model.json";
    @Parameter(defaultValue="${session}", readonly=true, required=true)
    private MavenSession session;
    @Component
    private ProjectDependenciesResolver dependenciesResolver;
    @Component
    private MavenProjectHelper projectHelper;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (Boolean.parseBoolean(System.getProperty("mule.maven.extension.model.disable", "false"))) {
            this.getLog().info((CharSequence)"Extension Model generation skipped.");
            return;
        }
        System.setProperty("mule.forceExtensionValidation", "true");
        MulePluginModel mulePluginDescriber = this.getMulePluginModel();
        MavenProjectExtensionModelLoader extensionModelLoader = new MavenProjectExtensionModelLoader(this.getLog());
        ExtensionModel extensionModel = extensionModelLoader.loadExtension(this.project, this.session, this.dependenciesResolver, mulePluginDescriber);
        String serializedExtensionModel = new ExtensionModelJsonSerializer(true).serialize(extensionModel);
        File generatedExtensionModelFile = new File(this.outputDirectory, TEMPORAL_EXTENSION_MODEL_JSON);
        try (PrintWriter out = new PrintWriter(generatedExtensionModelFile);){
            out.println(serializedExtensionModel);
        }
        catch (FileNotFoundException e) {
            throw new MojoFailureException(String.format("Failure while saving the serialized ExtensionModel to the file [%s]", generatedExtensionModelFile.getAbsolutePath()));
        }
        this.projectHelper.attachArtifact(this.project, "json", "extension-model-" + mulePluginDescriber.getMinMuleVersion(), generatedExtensionModelFile);
    }

    private MulePluginModel getMulePluginModel() throws MojoFailureException {
        MulePluginModel mulePluginModel = MulePluginJsonDescriberLoader.loadMulePluginDescriber(this.outputDirectory);
        if (mulePluginModel.getExtensionModelLoaderDescriptor().isPresent() && "xml-based".equals(((MuleArtifactLoaderDescriptor)mulePluginModel.getExtensionModelLoaderDescriptor().get()).getId())) {
            mulePluginModel.getExtensionModelLoaderDescriptor().ifPresent(muleArtifactLoaderDescriptor -> muleArtifactLoaderDescriptor.getAttributes().put("validate-xml", true));
        }
        return mulePluginModel;
    }
}

