/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.maven.loader;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.DefaultDependencyResolutionRequest;
import org.apache.maven.project.DependencyResolutionException;
import org.apache.maven.project.DependencyResolutionRequest;
import org.apache.maven.project.DependencyResolutionResult;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectDependenciesResolver;
import org.eclipse.aether.graph.DependencyFilter;
import org.eclipse.aether.graph.DependencyNode;
import org.eclipse.aether.util.filter.AndDependencyFilter;
import org.eclipse.aether.util.filter.ScopeDependencyFilter;
import org.mule.extension.maven.util.MulePluginArtifactLoaderUtils;
import org.mule.runtime.api.deployment.meta.MuleArtifactLoaderDescriptor;
import org.mule.runtime.api.deployment.meta.MulePluginModel;
import org.mule.runtime.api.dsl.DslResolvingContext;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.extension.api.loader.ExtensionModelLoader;

public class MavenProjectExtensionModelLoader {
    private final Log log;

    public MavenProjectExtensionModelLoader(Log log) {
        this.log = log;
    }

    public ExtensionModel loadExtension(MavenProject project, MavenSession session, ProjectDependenciesResolver dependenciesResolver, MulePluginModel mulePluginDescriber) throws MojoFailureException, MojoExecutionException {
        ClassLoader pluginClassLoader = this.getInvokerClassLoader(project);
        Set<ExtensionModel> extensions = this.getPluginsExtensions(project, session, dependenciesResolver, pluginClassLoader);
        return this.getExtensionModel(pluginClassLoader, extensions, mulePluginDescriber);
    }

    private Set<ExtensionModel> getPluginsExtensions(MavenProject project, MavenSession session, ProjectDependenciesResolver dependenciesResolver, ClassLoader pluginClassLoader) throws MojoFailureException, MojoExecutionException {
        LinkedHashSet<ExtensionModel> extensions = new LinkedHashSet<ExtensionModel>();
        for (MulePluginModel mulePluginDescriber : this.filterPluginsWithExtensionModelLoader(project, session, dependenciesResolver)) {
            extensions.add(this.getExtensionModel(pluginClassLoader, extensions, mulePluginDescriber));
        }
        return extensions;
    }

    private Set<MulePluginModel> filterPluginsWithExtensionModelLoader(MavenProject project, MavenSession session, ProjectDependenciesResolver dependenciesResolver) throws MojoExecutionException {
        DefaultDependencyResolutionRequest request = new DefaultDependencyResolutionRequest(project, session.getRepositorySession());
        request.setResolutionFilter(AndDependencyFilter.newInstance((DependencyFilter)new ScopeDependencyFilter(new String[]{"test"}), (node, parents) -> "mule-plugin".equals(node.getArtifact().getClassifier())));
        HashSet<Pair<String, String>> dependenciesByGroupArtifactId = new HashSet<Pair<String, String>>();
        try {
            DependencyResolutionResult result = dependenciesResolver.resolve((DependencyResolutionRequest)request);
            ArrayList<DependencyNode> seenNodes = new ArrayList<DependencyNode>();
            seenNodes.add(result.getDependencyGraph());
            this.populateDependenciesTransitively(dependenciesByGroupArtifactId, result.getDependencyGraph().getChildren(), seenNodes);
        }
        catch (DependencyResolutionException e) {
            throw new MojoExecutionException("Error building dependency graph.", (Exception)((Object)e));
        }
        return project.getArtifacts().stream().filter(artifact -> !"test".equals(artifact.getScope())).sorted((o1, o2) -> {
            if (dependenciesByGroupArtifactId.contains(Pair.of((Object)(o1.getGroupId() + ":" + o1.getArtifactId()), (Object)(o2.getGroupId() + ":" + o2.getArtifactId())))) {
                return 1;
            }
            if (dependenciesByGroupArtifactId.contains(Pair.of((Object)(o2.getGroupId() + ":" + o2.getArtifactId()), (Object)(o1.getGroupId() + ":" + o1.getArtifactId())))) {
                return -1;
            }
            return 0;
        }).map(MulePluginArtifactLoaderUtils::readMulePluginModel).filter(Optional::isPresent).map(Optional::get).filter(mulePluginModel -> mulePluginModel.getExtensionModelLoaderDescriptor().isPresent()).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    private void populateDependenciesTransitively(Set<Pair<String, String>> dependenciesByGroupArtifactId, List<DependencyNode> children, List<DependencyNode> seenNodes) {
        for (DependencyNode depNode : children) {
            if ("test".equals(depNode.getDependency().getScope()) || !"mule-plugin".equals(depNode.getArtifact().getClassifier())) continue;
            ArrayList<DependencyNode> localSeenNodes = new ArrayList<DependencyNode>(seenNodes);
            localSeenNodes.add(depNode);
            for (DependencyNode localSeenNode : localSeenNodes) {
                String depNodeId;
                String localSeenNodeId = localSeenNode.getArtifact().getGroupId() + ":" + localSeenNode.getArtifact().getArtifactId();
                if (localSeenNodeId.equals(depNodeId = depNode.getArtifact().getGroupId() + ":" + depNode.getArtifact().getArtifactId())) continue;
                dependenciesByGroupArtifactId.add((Pair<String, String>)Pair.of((Object)localSeenNodeId, (Object)depNodeId));
            }
            this.populateDependenciesTransitively(dependenciesByGroupArtifactId, depNode.getChildren(), localSeenNodes);
        }
    }

    private ExtensionModel getExtensionModel(ClassLoader pluginClassLoader, Set<ExtensionModel> extensions, MulePluginModel mulePluginDescriber) throws MojoExecutionException, MojoFailureException {
        MuleArtifactLoaderDescriptor loaderDescriptor = this.getExtensionLoaderDescriptor(mulePluginDescriber);
        this.log.debug((CharSequence)String.format("Creating ExtensionModel for name:[%s], ID:[%s]", mulePluginDescriber.getName(), loaderDescriptor.getId()));
        ExtensionModelLoader extensionModelLoader = this.getExtensionModelLoader(loaderDescriptor.getId(), pluginClassLoader);
        return extensionModelLoader.loadExtensionModel(pluginClassLoader, DslResolvingContext.getDefault(extensions), loaderDescriptor.getAttributes());
    }

    private MuleArtifactLoaderDescriptor getExtensionLoaderDescriptor(MulePluginModel jsonDescriber) throws MojoExecutionException, MojoFailureException {
        return (MuleArtifactLoaderDescriptor)jsonDescriber.getExtensionModelLoaderDescriptor().orElseThrow(() -> new MojoExecutionException(String.format("The plugin [%s] does not have a ExtensionLoader descriptor, nothing to generate so far.", jsonDescriber.getName())));
    }

    private ClassLoader getInvokerClassLoader(MavenProject project) throws MojoFailureException {
        List invokerClasspathElements;
        try {
            invokerClasspathElements = project.getCompileClasspathElements();
        }
        catch (DependencyResolutionRequiredException e) {
            throw new MojoFailureException("There was an issue trying to consume the classpath for the current project.", (Throwable)e);
        }
        invokerClasspathElements.add(project.getBuild().getOutputDirectory());
        if (this.log.isDebugEnabled()) {
            this.log.debug((CharSequence)String.format("Classpath to process: [%s]", String.join((CharSequence)",", invokerClasspathElements)));
        }
        URL[] urls = new URL[invokerClasspathElements.size()];
        for (int i = 0; i < invokerClasspathElements.size(); ++i) {
            String invokerClasspathElement = (String)invokerClasspathElements.get(i);
            try {
                urls[i] = new File(invokerClasspathElement).toURI().toURL();
                continue;
            }
            catch (MalformedURLException e) {
                throw new MojoFailureException(String.format("There was an issue trying to convert the element [%s] to an URL. Full classpath: [%s]", invokerClasspathElement, String.join((CharSequence)",", invokerClasspathElements)));
            }
        }
        return new URLClassLoader(urls, this.getClass().getClassLoader());
    }

    private ExtensionModelLoader getExtensionModelLoader(String id, ClassLoader pluginClassLoader) throws MojoFailureException {
        ArrayList<String> foundIds = new ArrayList<String>();
        ServiceLoader<ExtensionModelLoader> extensionModelLoaders = ServiceLoader.load(ExtensionModelLoader.class, pluginClassLoader);
        for (ExtensionModelLoader extensionModelLoader : extensionModelLoaders) {
            foundIds.add(String.format("Class:[%s]; ID:[%s].", extensionModelLoader.getClass().getName(), extensionModelLoader.getId()));
            if (!id.equals(extensionModelLoader.getId())) continue;
            return extensionModelLoader;
        }
        throw new MojoFailureException(String.format("Failure while looking for an implementation class of [%s] class through SPI for the ID [%s]. Found resources: \n%s", ExtensionModelLoader.class.getName(), id, String.join((CharSequence)", \n", foundIds)));
    }
}

