/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.maven;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.ArtifactUtils;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.descriptor.PluginDescriptor;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProjectHelper;
import org.apache.maven.project.ProjectDependenciesResolver;
import org.mule.extension.maven.loader.MavenProjectExtensionModelLoader;
import org.mule.extension.maven.loader.MulePluginJsonDescriberLoader;
import org.mule.plugin.maven.AbstractMuleMojo;
import org.mule.runtime.api.deployment.meta.MulePluginModel;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.extension.api.persistence.ExtensionModelJsonSerializer;

@Mojo(name="extension-model", defaultPhase=LifecyclePhase.PACKAGE, requiresDependencyResolution=ResolutionScope.TEST, threadSafe=true)
public class ExtensionModelMojo
extends AbstractMuleMojo {
    public static final String TEMPORAL_EXTENSION_MODEL_JSON = "temporal-extension-model.json";
    public static final String SKIP_EXTENSION_MODEL_VALIDATION = "skipExtensionModelValidation";
    private static final String ORG_MULE_RUNTIME = "org.mule.runtime";
    private static final String COM_MULESOFT_MULE_RUNTIME_MODULES = "com.mulesoft.mule.runtime.modules";
    @Parameter(defaultValue="${session}", readonly=true, required=true)
    private MavenSession session;
    @Component
    private ProjectDependenciesResolver dependenciesResolver;
    @Component
    private MavenProjectHelper projectHelper;
    @Parameter(defaultValue="${plugin}", readonly=true)
    private PluginDescriptor pluginDescriptor;
    @Parameter(defaultValue="false", property="skipExtensionModelValidation")
    private Boolean skipExtensionModelValidation;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (Boolean.parseBoolean(System.getProperty("mule.maven.extension.model.disable", "false"))) {
            this.getLog().info((CharSequence)"Extension Model generation skipped.");
            return;
        }
        if (this.skipExtensionModelValidation.booleanValue()) {
            this.getLog().warn((CharSequence)"Extension Model generation will be done by omitting validations, thus it wil not validate it's syntactically correct (BE SURE TO TEST THE CONNECTOR).");
        }
        System.setProperty("mule.forceExtensionValidation", String.valueOf(this.skipExtensionModelValidation));
        MulePluginModel mulePluginDescriber = MulePluginJsonDescriberLoader.loadMulePluginDescriber(this.outputDirectory);
        MavenProjectExtensionModelLoader extensionModelLoader = new MavenProjectExtensionModelLoader(this.getLog());
        this.enrichPluginClassLoader();
        ExtensionModel extensionModel = extensionModelLoader.loadExtension(this.project, this.session);
        String serializedExtensionModel = new ExtensionModelJsonSerializer(true).serialize(extensionModel);
        File generatedExtensionModelFile = new File(this.outputDirectory, TEMPORAL_EXTENSION_MODEL_JSON);
        try (PrintWriter out = new PrintWriter(generatedExtensionModelFile);){
            out.println(serializedExtensionModel);
        }
        catch (FileNotFoundException e) {
            throw new MojoFailureException(String.format("Failure while saving the serialized ExtensionModel to the file [%s]", generatedExtensionModelFile.getAbsolutePath()));
        }
        this.projectHelper.attachArtifact(this.project, "json", "extension-model-" + mulePluginDescriber.getMinMuleVersion(), generatedExtensionModelFile);
    }

    private void enrichPluginClassLoader() throws MojoExecutionException {
        List pluginRuntimeLibraries = this.pluginDescriptor.getArtifacts().stream().filter(artifact -> artifact.getGroupId().equals(ORG_MULE_RUNTIME) || artifact.getGroupId().equals(COM_MULESOFT_MULE_RUNTIME_MODULES)).map(ArtifactUtils::versionlessKey).collect(Collectors.toList());
        List runtimeProvidedLibraries = this.project.getArtifacts().stream().filter(artifact -> artifact.getScope().equals("provided")).filter(artifact -> artifact.getGroupId().equals(ORG_MULE_RUNTIME) || artifact.getGroupId().equals(COM_MULESOFT_MULE_RUNTIME_MODULES)).filter(artifact -> artifact.getType().equals("jar")).filter(artifact -> !this.pluginDescriptor.getArtifacts().contains(artifact)).filter(artifact -> !pluginRuntimeLibraries.contains(ArtifactUtils.versionlessKey((Artifact)artifact))).collect(Collectors.toList());
        for (Artifact runtimeProvidedLibrary : runtimeProvidedLibraries) {
            this.getLog().info((CharSequence)String.format("Adding URL to plugin class loader for provided Mule Runtime library: %s", runtimeProvidedLibrary));
            try {
                this.pluginDescriptor.getClassRealm().addURL(runtimeProvidedLibrary.getFile().toURI().toURL());
            }
            catch (MalformedURLException e) {
                throw new MojoExecutionException("Error while getting Mule Runtime provided library from project", (Exception)e);
            }
        }
    }
}

