/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.extension.maven.documentation;

import org.apache.commons.lang.RandomStringUtils;
import org.junit.Test;

import java.util.UUID;

import static org.hamcrest.core.Is.is;
import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertThat;
import static org.mule.extension.maven.documentation.NameUtils.normalize;

public class NameNormalizerTestCase {

  @Test
  public void hyphenized() {
    String normalized = normalize("This-Is-A-Hyphenized-Name");
    assertThat(normalized, is("ThisIsAHyphenizedName"));
  }

  @Test
  public void withSpaces() {
    String normalized = normalize("This is a name with spaces");
    assertThat(normalized, is("ThisIsANameWithSpaces"));
  }

  @Test
  public void camel() {
    String normalized = normalize("camelCaseName");
    assertThat(normalized, is("CamelCaseName"));
  }

  @Test
  public void underscore() {
    String normalized = normalize("this_is_an_underscored_name");
    assertThat(normalized, is("This_is_an_underscored_name"));
  }

  @Test
  public void idempotency() {
    for (int i = 0; i < 5000; i++) {
      String randomString = RandomStringUtils.randomAlphabetic(30);
      String normalized = normalize(randomString);
      String renormalized = normalize(normalized);
      assertEquals(normalized, renormalized);
    }
  }
}
