/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.extension.maven.documentation;

import static org.hamcrest.core.Is.is;
import static org.junit.Assert.assertThat;
import static org.mule.extension.maven.documentation.NameUtils.prettify;

import org.junit.Test;

public class NamePrettifierTestCase {

  @Test
  public void hyphenized() {
    String prettified = prettify("this-is-a-hyphenized-name");
    assertThat(prettified, is("This Is A Hyphenized Name"));
  }

  @Test
  public void camel() {
    String prettified = prettify("camelCaseName");
    assertThat(prettified, is("Camel Case Name"));
  }

  @Test
  public void mixed() {
    String prettified = prettify("Camel-with-someHyphen");
    assertThat(prettified, is("Camel With Some Hyphen"));
  }

  @Test
  public void uppercaseNextToEachOther() {
    String prettified = prettify("HTTP");
    assertThat(prettified, is("HTTP"));

    prettified = prettify("someHTTPName");
    assertThat(prettified, is("Some HTTP Name"));
  }

  @Test
  public void complex() {
    String prettified = prettify("HTTP-WithComplex-content-AndMoreStuff");
    assertThat(prettified, is("HTTP With Complex Content And More Stuff"));
  }
}
