/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.maven.loader;

import com.google.common.io.Files;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.ArtifactUtils;
import org.apache.maven.execution.MavenExecutionRequest;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Model;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.mule.extension.maven.loader.MuleArtifactResourcesRegistry;
import org.mule.maven.client.api.MavenReactorResolver;
import org.mule.maven.client.api.model.BundleDescriptor;
import org.mule.maven.client.api.model.MavenConfiguration;
import org.mule.maven.client.internal.DefaultSettingsSupplierFactory;
import org.mule.maven.client.internal.MavenEnvironmentVariables;
import org.mule.runtime.api.deployment.meta.AbstractMuleArtifactModel;
import org.mule.runtime.api.deployment.meta.MuleApplicationModel;
import org.mule.runtime.api.deployment.meta.MuleArtifactLoaderDescriptor;
import org.mule.runtime.api.deployment.meta.Product;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.util.Pair;
import org.mule.runtime.container.api.ModuleRepository;
import org.mule.runtime.container.internal.ContainerModuleDiscoverer;
import org.mule.runtime.container.internal.DefaultModuleRepository;
import org.mule.runtime.container.internal.ModuleDiscoverer;
import org.mule.runtime.core.api.config.MuleManifest;
import org.mule.runtime.core.api.util.UUID;
import org.mule.runtime.deployment.model.api.artifact.extension.ExtensionModelDiscoverer;
import org.mule.runtime.deployment.model.api.artifact.extension.ExtensionModelLoaderRepository;
import org.mule.runtime.deployment.model.internal.artifact.extension.MuleExtensionModelLoaderManager;
import org.mule.runtime.extension.api.loader.ExtensionModelLoader;
import org.mule.runtime.globalconfig.api.GlobalConfigLoader;
import org.mule.runtime.module.artifact.activation.api.classloader.ArtifactClassLoaderResolver;
import org.mule.runtime.module.artifact.api.classloader.ArtifactClassLoader;
import org.mule.runtime.module.artifact.api.classloader.MuleDeployableArtifactClassLoader;
import org.mule.runtime.module.artifact.api.descriptor.ApplicationDescriptor;
import org.mule.runtime.module.artifact.api.descriptor.ArtifactPluginDescriptor;
import org.mule.runtime.module.deployment.impl.internal.maven.MavenUtils;

public class MavenProjectExtensionModelLoader {
    private final Log log;

    public MavenProjectExtensionModelLoader(Log log) {
        this.log = log;
    }

    public ExtensionModel loadExtension(MavenProject project, MavenSession session) throws MojoFailureException, MojoExecutionException {
        String artifactId = project.getArtifactId();
        this.log.debug((CharSequence)String.format("Creating ExtensionModel for:[%s]", artifactId));
        this.configureMavenClient(session);
        MuleArtifactResourcesRegistry muleArtifactResourcesRegistry = new MuleArtifactResourcesRegistry(pluginDescriptor -> pluginDescriptor.getPluginFile().equals(project.getArtifact().getFile()) && "xml-based".equals(pluginDescriptor.getMuleArtifactLoaderDescriptor().getId()));
        HashMap<String, Object> classLoaderModelAttributes = new HashMap<String, Object>();
        classLoaderModelAttributes.put("_classLoaderModelMavenReactorResolver", new PluginFileMavenReactor(project));
        return this.withPluginClassLoaders(project.getArtifact(), classLoaderModelAttributes, muleArtifactResourcesRegistry, artifactPluginClassLoaders -> this.doLoadExtensionModel(project.getArtifact(), artifactPluginClassLoaders, muleArtifactResourcesRegistry.getContainerArtifactClassLoader()));
    }

    public ExtensionModel loadExtension(Artifact artifact, MavenSession session) throws MojoFailureException, MojoExecutionException {
        this.log.debug((CharSequence)String.format("Creating ExtensionModel for:[%s]", artifact.getArtifactId()));
        this.configureMavenClient(session);
        MuleArtifactResourcesRegistry muleArtifactResourcesRegistry = new MuleArtifactResourcesRegistry(pluginDescriptor -> false);
        HashMap<String, Object> classLoaderModelAttributes = new HashMap<String, Object>();
        return this.withPluginClassLoaders(artifact, classLoaderModelAttributes, muleArtifactResourcesRegistry, artifactPluginClassLoaders -> this.doLoadExtensionModel(artifact, artifactPluginClassLoaders, muleArtifactResourcesRegistry.getContainerArtifactClassLoader()));
    }

    private Set<Pair<ArtifactPluginDescriptor, ExtensionModel>> discoverPluginsExtensionModel(List<ArtifactClassLoader> artifactPluginClassLoaders, MuleExtensionModelLoaderManager extensionModelLoaderRepository) {
        List artifacts = artifactPluginClassLoaders.stream().map(a -> new Pair((Object)a.getArtifactDescriptor(), a)).collect(Collectors.toList());
        return new ExtensionModelDiscoverer().discoverPluginsExtensionModels((ExtensionModelLoaderRepository)extensionModelLoaderRepository, artifacts);
    }

    private void configureMavenClient(MavenSession session) {
        MavenConfiguration.MavenConfigurationBuilder mavenConfigurationBuilder = MavenConfiguration.newMavenConfigurationBuilder();
        DefaultSettingsSupplierFactory settingsSupplierFactory = new DefaultSettingsSupplierFactory(new MavenEnvironmentVariables());
        MavenExecutionRequest request = session.getRequest();
        mavenConfigurationBuilder.localMavenRepositoryLocation(request.getLocalRepositoryPath());
        mavenConfigurationBuilder.userSettingsLocation(request.getUserSettingsFile());
        mavenConfigurationBuilder.globalSettingsLocation(request.getGlobalSettingsFile());
        settingsSupplierFactory.environmentSettingsSecuritySupplier().ifPresent(arg_0 -> ((MavenConfiguration.MavenConfigurationBuilder)mavenConfigurationBuilder).settingsSecurityLocation(arg_0));
        mavenConfigurationBuilder.userProperties(request.getUserProperties());
        mavenConfigurationBuilder.activeProfiles(request.getActiveProfiles());
        mavenConfigurationBuilder.inactiveProfiles(request.getInactiveProfiles());
        mavenConfigurationBuilder.ignoreArtifactDescriptorRepositories(false);
        GlobalConfigLoader.setMavenConfig((MavenConfiguration)mavenConfigurationBuilder.build());
    }

    private ExtensionModel doLoadExtensionModel(Artifact artifact, List<ArtifactClassLoader> artifactPluginClassLoaders, ArtifactClassLoader containerArtifactClassLoader) throws MojoFailureException {
        MuleExtensionModelLoaderManager extensionModelLoaderRepository = new MuleExtensionModelLoaderManager(containerArtifactClassLoader);
        try {
            extensionModelLoaderRepository.start();
        }
        catch (MuleException e) {
            throw new MojoFailureException(String.format("Failure while looking implementation classes of [%s] class through SPI", ExtensionModelLoader.class.getName()), (Throwable)e);
        }
        Set<Pair<ArtifactPluginDescriptor, ExtensionModel>> discoverPluginsExtensionModel = this.discoverPluginsExtensionModel(artifactPluginClassLoaders, extensionModelLoaderRepository);
        Optional<ExtensionModel> extensionModelOptional = discoverPluginsExtensionModel.stream().filter(pair -> {
            org.mule.runtime.module.artifact.api.descriptor.BundleDescriptor bundleDescriptor = ((ArtifactPluginDescriptor)pair.getFirst()).getBundleDescriptor();
            return bundleDescriptor.getGroupId().equals(artifact.getGroupId()) && bundleDescriptor.getArtifactId().equals(artifact.getArtifactId()) && bundleDescriptor.getVersion().equals(artifact.getVersion());
        }).findFirst().map(Pair::getSecond);
        if (!extensionModelOptional.isPresent()) {
            List foundExtensionModels = discoverPluginsExtensionModel.stream().map(pair -> ((ExtensionModel)pair.getSecond()).getName()).collect(Collectors.toList());
            if (foundExtensionModels.isEmpty()) {
                throw new MojoFailureException(String.format("Could not load Extension Model for %s", ArtifactUtils.key((Artifact)artifact)));
            }
            throw new MojoFailureException(String.format("Could not load Extension Model for %s, the following were loaded: %n%s", ArtifactUtils.key((Artifact)artifact), String.join((CharSequence)String.format(", %n", new Object[0]), foundExtensionModels)));
        }
        return extensionModelOptional.get();
    }

    /*
     * Loose catch block
     */
    private <T> T withPluginClassLoaders(Artifact artifact, Map<String, Object> classLoaderModelLoaderAttributes, MuleArtifactResourcesRegistry muleArtifactResourcesRegistry, Action<T> action) throws MojoFailureException, MojoExecutionException {
        String uuid = UUID.getUUID();
        String applicationName = uuid + "-extension-model-temp-app";
        File applicationFolder = new File(Files.createTempDir(), applicationName);
        try {
            T t;
            this.createPomFile(artifact, uuid, applicationFolder);
            MuleApplicationModel muleApplicationModel = (MuleApplicationModel)((MuleApplicationModel.MuleApplicationModelBuilder)((MuleApplicationModel.MuleApplicationModelBuilder)((MuleApplicationModel.MuleApplicationModelBuilder)((MuleApplicationModel.MuleApplicationModelBuilder)((MuleApplicationModel.MuleApplicationModelBuilder)new MuleApplicationModel.MuleApplicationModelBuilder().setMinMuleVersion(MuleManifest.getProductVersion())).setName(applicationName)).setRequiredProduct(Product.MULE)).withBundleDescriptorLoader(new MuleArtifactLoaderDescriptor("mule", Collections.emptyMap()))).withClassLoaderModelDescriptorLoader(new MuleArtifactLoaderDescriptor("mule", classLoaderModelLoaderAttributes))).build();
            ApplicationDescriptor artifactDescriptor = (ApplicationDescriptor)muleArtifactResourcesRegistry.getApplicationDescriptorFactory().createArtifact(applicationFolder, Optional.empty(), (AbstractMuleArtifactModel)muleApplicationModel);
            ArtifactClassLoaderResolver artifactClassLoaderResolver = ArtifactClassLoaderResolver.classLoaderResolver((ModuleRepository)new DefaultModuleRepository((ModuleDiscoverer)new ContainerModuleDiscoverer(ArtifactClassLoaderResolver.class.getClassLoader())), empty -> applicationFolder);
            muleArtifactResourcesRegistry.getPluginDependenciesResolver().resolve(Collections.emptySet(), new ArrayList(artifactDescriptor.getPlugins()), false);
            MuleDeployableArtifactClassLoader artifactClassLoader = artifactClassLoaderResolver.createApplicationClassLoader(artifactDescriptor, muleArtifactResourcesRegistry::getContainerArtifactClassLoader);
            try {
                t = action.call(artifactClassLoader.getArtifactPluginClassLoaders());
            }
            catch (Exception e) {
                throw new MojoFailureException("Error while generating class loaders in order to load the Extension Model", (Throwable)e);
            }
            finally {
                if (artifactClassLoader != null) {
                    artifactClassLoader.dispose();
                }
            }
            return t;
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            FileUtils.deleteQuietly((File)applicationFolder);
        }
    }

    private void createPomFile(Artifact artifact, String uuid, File applicationFolder) {
        Model model = new Model();
        model.setGroupId(uuid);
        model.setArtifactId(uuid);
        model.setVersion(MuleManifest.getProductVersion());
        model.setPackaging("mule-application");
        model.setModelVersion("4.0.0");
        Dependency dependency = new Dependency();
        dependency.setGroupId(artifact.getGroupId());
        dependency.setArtifactId(artifact.getArtifactId());
        dependency.setVersion(artifact.getVersion());
        dependency.setClassifier("mule-plugin");
        dependency.setType("jar");
        model.getDependencies().add(dependency);
        MavenUtils.createDeployablePomFile((File)applicationFolder, (Model)model);
        MavenUtils.createDeployablePomProperties((File)applicationFolder, (Model)model);
    }

    @FunctionalInterface
    static interface Action<T> {
        public T call(List<ArtifactClassLoader> var1) throws MojoFailureException, MojoExecutionException;
    }

    class PluginFileMavenReactor
    implements MavenReactorResolver {
        private final MavenProject project;

        public PluginFileMavenReactor(MavenProject project) {
            this.project = project;
        }

        public File findArtifact(BundleDescriptor bundleDescriptor) {
            if (this.checkArtifact(bundleDescriptor)) {
                if (bundleDescriptor.getType().equals("pom")) {
                    return this.project.getFile();
                }
                return this.project.getArtifact().getFile();
            }
            return null;
        }

        private boolean checkArtifact(BundleDescriptor bundleDescriptor) {
            return bundleDescriptor.getGroupId().equals(this.project.getArtifact().getGroupId()) && bundleDescriptor.getArtifactId().equals(this.project.getArtifact().getArtifactId()) && bundleDescriptor.getVersion().equals(this.project.getArtifact().getVersion());
        }

        public List<String> findVersions(BundleDescriptor bundleDescriptor) {
            if (this.checkArtifact(bundleDescriptor)) {
                return Collections.singletonList(this.project.getArtifact().getVersion());
            }
            return Collections.emptyList();
        }
    }
}

