/**
 * (c) 2003-2015 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.extension.maven.loader;

import static org.mule.runtime.module.artifact.api.descriptor.ArtifactDescriptorConstants.MULE_LOADER_ID;

import static java.lang.String.format;
import org.mule.runtime.core.api.config.bootstrap.ArtifactType;
import org.mule.runtime.module.artifact.api.descriptor.ClassLoaderModel;
import org.mule.runtime.module.artifact.api.descriptor.ClassLoaderModelLoader;
import org.mule.runtime.module.artifact.api.descriptor.InvalidDescriptorLoaderException;

import java.io.File;
import java.util.List;
import java.util.Map;

public class CompositeClassLoaderModelLoader implements ClassLoaderModelLoader {

  private List<ClassLoaderModelLoader> classLoaderModelLoaders;

  public CompositeClassLoaderModelLoader(List<ClassLoaderModelLoader> classLoaderModelLoaders) {
    this.classLoaderModelLoaders = classLoaderModelLoaders;
  }

  @Override
  public String getId() {
    return MULE_LOADER_ID;
  }

  @Override
  public ClassLoaderModel load(File artifactFile, Map<String, Object> attributes, ArtifactType artifactType)
      throws InvalidDescriptorLoaderException {
    for (ClassLoaderModelLoader classLoaderModelLoader : classLoaderModelLoaders) {
      if (classLoaderModelLoader.supportsArtifactType(artifactType)) {
        return classLoaderModelLoader.load(artifactFile, attributes, artifactType);
      }
    }
    throw new IllegalStateException(format("Artifact type %s not supported", artifactType));
  }

  @Override
  public boolean supportsArtifactType(ArtifactType artifactType) {
    return classLoaderModelLoaders.stream()
        .anyMatch(classLoaderModelLoader -> classLoaderModelLoader.supportsArtifactType(artifactType));
  }
}
