/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.maven.loader;

import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.nio.file.Paths;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.function.Predicate;
import org.apache.commons.io.FileUtils;
import org.mule.runtime.api.deployment.meta.AbstractMuleArtifactModel;
import org.mule.runtime.api.deployment.meta.MuleApplicationModel;
import org.mule.runtime.api.deployment.meta.MuleArtifactLoaderDescriptor;
import org.mule.runtime.api.deployment.meta.MuleArtifactLoaderDescriptorBuilder;
import org.mule.runtime.api.deployment.meta.MulePluginModel;
import org.mule.runtime.api.deployment.meta.Product;
import org.mule.runtime.api.deployment.persistence.AbstractMuleArtifactModelJsonSerializer;
import org.mule.runtime.api.deployment.persistence.MulePluginModelJsonSerializer;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.container.api.ContainerClassLoaderProvider;
import org.mule.runtime.container.api.ModuleRepository;
import org.mule.runtime.core.api.config.bootstrap.ArtifactType;
import org.mule.runtime.core.internal.util.JarUtils;
import org.mule.runtime.deployment.model.api.artifact.ArtifactDescriptorFactoryProvider;
import org.mule.runtime.deployment.model.api.artifact.DescriptorLoaderRepositoryFactory;
import org.mule.runtime.deployment.model.api.plugin.resolver.PluginDependenciesResolver;
import org.mule.runtime.module.artifact.api.classloader.ArtifactClassLoader;
import org.mule.runtime.module.artifact.api.descriptor.AbstractArtifactDescriptorFactory;
import org.mule.runtime.module.artifact.api.descriptor.ApplicationDescriptor;
import org.mule.runtime.module.artifact.api.descriptor.ArtifactDescriptorCreateException;
import org.mule.runtime.module.artifact.api.descriptor.ArtifactDescriptorFactory;
import org.mule.runtime.module.artifact.api.descriptor.ArtifactDescriptorValidatorBuilder;
import org.mule.runtime.module.artifact.api.descriptor.ArtifactPluginDescriptor;
import org.mule.runtime.module.artifact.api.descriptor.BundleDescriptor;
import org.mule.runtime.module.artifact.api.descriptor.DescriptorLoaderRepository;
import org.mule.runtime.module.artifact.api.plugin.LoaderDescriber;
import org.mule.runtime.module.deployment.impl.internal.plugin.PluginExtendedBundleDescriptorAttributes;
import org.mule.runtime.module.deployment.impl.internal.plugin.PluginExtendedClassLoaderConfigurationAttributes;
import org.mule.runtime.module.deployment.impl.internal.plugin.PluginExtendedDeploymentProperties;

public class MuleArtifactResourcesRegistry {
    private final AbstractArtifactDescriptorFactory<MuleApplicationModel, ApplicationDescriptor> applicationDescriptorFactory;
    private final PluginDependenciesResolver pluginDependenciesResolver;
    private final ArtifactClassLoader containerArtifactClassLoader;

    public MuleArtifactResourcesRegistry(Predicate<PluginDescriptor> enableXmlValidations) {
        DescriptorLoaderRepository descriptorLoaderRepository = new DescriptorLoaderRepositoryFactory().createDescriptorLoaderRepository();
        ModuleRepository moduleRepository = ModuleRepository.createModuleRepository((ClassLoader)this.getClass().getClassLoader(), (File)Files.createTempDir());
        ArtifactDescriptorValidatorBuilder artifactDescriptorValidatorBuilder = ArtifactDescriptorValidatorBuilder.builder();
        ArtifactPluginDescriptorFactoryExtension artifactPluginDescriptorFactory = new ArtifactPluginDescriptorFactoryExtension(descriptorLoaderRepository, artifactDescriptorValidatorBuilder, enableXmlValidations);
        this.applicationDescriptorFactory = ArtifactDescriptorFactoryProvider.artifactDescriptorFactoryProvider().createApplicationDescriptorFactory((ArtifactDescriptorFactory)artifactPluginDescriptorFactory, descriptorLoaderRepository, artifactDescriptorValidatorBuilder);
        this.pluginDependenciesResolver = ArtifactDescriptorFactoryProvider.artifactDescriptorFactoryProvider().createBundlePluginDependenciesResolver((ArtifactDescriptorFactory)artifactPluginDescriptorFactory);
        this.containerArtifactClassLoader = ContainerClassLoaderProvider.createContainerClassLoader((ModuleRepository)moduleRepository, (ClassLoader)this.getClass().getClassLoader());
    }

    public AbstractArtifactDescriptorFactory<MuleApplicationModel, ApplicationDescriptor> getApplicationDescriptorFactory() {
        return this.applicationDescriptorFactory;
    }

    public PluginDependenciesResolver getPluginDependenciesResolver() {
        return this.pluginDependenciesResolver;
    }

    public ArtifactClassLoader getContainerArtifactClassLoader() {
        return this.containerArtifactClassLoader;
    }

    private final class ArtifactPluginDescriptorFactoryExtension
    extends AbstractArtifactDescriptorFactory<MulePluginModel, ArtifactPluginDescriptor> {
        private final Predicate<PluginDescriptor> enableXmlValidations;

        private ArtifactPluginDescriptorFactoryExtension(DescriptorLoaderRepository descriptorLoaderRepository, ArtifactDescriptorValidatorBuilder artifactDescriptorValidatorBuilder, Predicate<PluginDescriptor> enableXmlValidations) {
            super(descriptorLoaderRepository, artifactDescriptorValidatorBuilder);
            this.enableXmlValidations = enableXmlValidations;
        }

        public ArtifactPluginDescriptor create(File pluginFile, Optional<Properties> deploymentProperties) {
            try {
                Optional<byte[]> jsonDescriptorContentOptional = Optional.empty();
                String mulePluginJsonPath = "META-INF/mule-artifact/mule-artifact.json";
                jsonDescriptorContentOptional = this.getMuleArtifactJsonDescriptorContent(pluginFile, jsonDescriptorContentOptional, mulePluginJsonPath);
                MulePluginModel artifactModel = jsonDescriptorContentOptional.map(jsonDescriptorContent -> (MulePluginModel)this.loadModelFromJson(new String((byte[])jsonDescriptorContent))).orElseThrow(() -> new ArtifactDescriptorCreateException(String.format("The plugin descriptor '%s' on plugin file '%s' is not present", mulePluginJsonPath, pluginFile)));
                MulePluginModel.MulePluginModelBuilder mulePluginModelBuilder = new MulePluginModel.MulePluginModelBuilder();
                ((MulePluginModel.MulePluginModelBuilder)((MulePluginModel.MulePluginModelBuilder)((MulePluginModel.MulePluginModelBuilder)((MulePluginModel.MulePluginModelBuilder)mulePluginModelBuilder.setName(artifactModel.getName())).setMinMuleVersion("4.1.1")).setRequiredProduct(Product.MULE)).withBundleDescriptorLoader(artifactModel.getBundleDescriptorLoader())).withClassLoaderModelDescriptorLoader(artifactModel.getClassLoaderModelLoaderDescriptor());
                artifactModel.getLicense().ifPresent(licenseModel -> mulePluginModelBuilder.withLicenseModel().setAllowsEvaluationLicense(licenseModel.isAllowsEvaluation()).setProvider(licenseModel.getProvider()).setRequiredEntitlement((String)licenseModel.getRequiredEntitlement().orElse(null)));
                artifactModel.getExtensionModelLoaderDescriptor().ifPresent(extensionModelDescriptorLoader -> {
                    MuleArtifactLoaderDescriptorBuilder muleArtifactLoaderDescriptorBuilder = mulePluginModelBuilder.withExtensionModelDescriber();
                    muleArtifactLoaderDescriptorBuilder.setId(extensionModelDescriptorLoader.getId());
                    extensionModelDescriptorLoader.getAttributes().entrySet().stream().forEach(entry -> muleArtifactLoaderDescriptorBuilder.addProperty((String)entry.getKey(), entry.getValue()));
                    if (artifactModel.getExtensionModelLoaderDescriptor().isPresent() && this.enableXmlValidations.test(new PluginDescriptor(pluginFile, (MuleArtifactLoaderDescriptor)artifactModel.getExtensionModelLoaderDescriptor().get()))) {
                        muleArtifactLoaderDescriptorBuilder.addProperty("validate-xml", (Object)true);
                    }
                });
                MulePluginModel pluginModel = mulePluginModelBuilder.build();
                return (ArtifactPluginDescriptor)this.loadFromJsonDescriptor(pluginFile, (AbstractMuleArtifactModel)pluginModel, deploymentProperties);
            }
            catch (ArtifactDescriptorCreateException e) {
                throw e;
            }
            catch (IOException e) {
                throw new ArtifactDescriptorCreateException((Throwable)e);
            }
        }

        private Optional<byte[]> getMuleArtifactJsonDescriptorContent(File pluginFile, Optional<byte[]> jsonDescriptorContentOptional, String mulePluginJsonPath) throws IOException {
            if (pluginFile.isFile()) {
                Preconditions.checkArgument((boolean)pluginFile.getName().endsWith(".jar"), (String)("provided file is not a plugin: " + pluginFile.getAbsolutePath()));
                jsonDescriptorContentOptional = JarUtils.loadFileContentFrom((File)pluginFile, (String)mulePluginJsonPath);
            } else {
                File mulePluginJsonFile = pluginFile.toPath().resolve(Paths.get("META-INF/mule-artifact", "mule-artifact.json")).toFile();
                if (mulePluginJsonFile.exists()) {
                    jsonDescriptorContentOptional = Optional.of(FileUtils.readFileToByteArray((File)mulePluginJsonFile));
                }
            }
            return jsonDescriptorContentOptional;
        }

        protected Map<String, Object> getClassLoaderConfigurationAttributes(Optional<Properties> deploymentPropertiesOptional, MuleArtifactLoaderDescriptor classLoaderModelLoaderDescriptor, BundleDescriptor bundleDescriptor) {
            Properties deploymentProperties;
            Map attributes = super.getClassLoaderConfigurationAttributes(deploymentPropertiesOptional, classLoaderModelLoaderDescriptor, bundleDescriptor);
            if (deploymentPropertiesOptional.isPresent() && (deploymentProperties = deploymentPropertiesOptional.get()) instanceof PluginExtendedDeploymentProperties) {
                PluginExtendedDeploymentProperties pluginExtendedDeploymentProperties = (PluginExtendedDeploymentProperties)deploymentProperties;
                return new PluginExtendedClassLoaderConfigurationAttributes(attributes, pluginExtendedDeploymentProperties.getDeployableArtifactDescriptor());
            }
            return attributes;
        }

        protected Map<String, Object> getBundleDescriptorAttributes(MuleArtifactLoaderDescriptor bundleDescriptorLoader, Optional<Properties> deploymentPropertiesOptional) {
            Properties deploymentProperties;
            Map attributes = super.getBundleDescriptorAttributes(bundleDescriptorLoader, deploymentPropertiesOptional);
            if (deploymentPropertiesOptional.isPresent() && (deploymentProperties = deploymentPropertiesOptional.get()) instanceof PluginExtendedDeploymentProperties) {
                PluginExtendedDeploymentProperties pluginExtendedDeploymentProperties = (PluginExtendedDeploymentProperties)deploymentProperties;
                return new PluginExtendedBundleDescriptorAttributes(attributes, pluginExtendedDeploymentProperties.getPluginBundleDescriptor());
            }
            return attributes;
        }

        protected ArtifactType getArtifactType() {
            return ArtifactType.PLUGIN;
        }

        protected AbstractMuleArtifactModelJsonSerializer<MulePluginModel> getMuleArtifactModelJsonSerializer() {
            return new MulePluginModelJsonSerializer();
        }

        protected void doDescriptorConfig(MulePluginModel artifactModel, ArtifactPluginDescriptor descriptor, File artifactLocation) {
            artifactModel.getExtensionModelLoaderDescriptor().ifPresent(extensionModelDescriptor -> {
                LoaderDescriber loaderDescriber = new LoaderDescriber(extensionModelDescriptor.getId());
                loaderDescriber.addAttributes(extensionModelDescriptor.getAttributes());
                descriptor.setExtensionModelDescriptorProperty(loaderDescriber);
            });
            artifactModel.getLicense().ifPresent(arg_0 -> ((ArtifactPluginDescriptor)descriptor).setLicenseModel(arg_0));
        }

        protected ArtifactPluginDescriptor createArtifactDescriptor(File artifactLocation, String name, Optional<Properties> deploymentProperties) {
            return new ArtifactPluginDescriptor(name);
        }
    }

    public static class PluginDescriptor {
        private final File pluginFile;
        private final MuleArtifactLoaderDescriptor muleArtifactLoaderDescriptor;

        public PluginDescriptor(File pluginFile, MuleArtifactLoaderDescriptor muleArtifactLoaderDescriptor) {
            this.pluginFile = pluginFile;
            this.muleArtifactLoaderDescriptor = muleArtifactLoaderDescriptor;
        }

        public File getPluginFile() {
            return this.pluginFile;
        }

        public MuleArtifactLoaderDescriptor getMuleArtifactLoaderDescriptor() {
            return this.muleArtifactLoaderDescriptor;
        }
    }
}

