/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.extension.maven.loader;

import org.mule.runtime.api.deployment.meta.MuleArtifactLoaderDescriptor;

import java.io.File;

public class PluginDescriptor {

  private final File pluginFile;
  private final MuleArtifactLoaderDescriptor muleArtifactLoaderDescriptor;

  public PluginDescriptor(File pluginFile, MuleArtifactLoaderDescriptor muleArtifactLoaderDescriptor) {
    this.pluginFile = pluginFile;
    this.muleArtifactLoaderDescriptor = muleArtifactLoaderDescriptor;
  }

  public File getPluginFile() {
    return pluginFile;
  }

  public MuleArtifactLoaderDescriptor getMuleArtifactLoaderDescriptor() {
    return muleArtifactLoaderDescriptor;
  }
}
