/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.extension.maven.loader;

import static org.mule.runtime.module.artifact.api.descriptor.ArtifactDescriptorConstants.MULE_LOADER_ID;

import static java.lang.String.format;
import org.mule.runtime.core.api.config.bootstrap.ArtifactType;
import org.mule.runtime.module.artifact.api.descriptor.ClassLoaderConfiguration;
import org.mule.runtime.module.artifact.api.descriptor.ClassLoaderConfigurationLoader;
import org.mule.runtime.module.artifact.api.descriptor.InvalidDescriptorLoaderException;

import java.io.File;
import java.util.List;
import java.util.Map;

public class CompositeClassLoaderConfigurationLoader implements ClassLoaderConfigurationLoader {

  private List<ClassLoaderConfigurationLoader> ClassLoaderConfigurationLoaders;

  public CompositeClassLoaderConfigurationLoader(List<ClassLoaderConfigurationLoader> ClassLoaderConfigurationLoaders) {
    this.ClassLoaderConfigurationLoaders = ClassLoaderConfigurationLoaders;
  }

  @Override
  public String getId() {
    return MULE_LOADER_ID;
  }

  @Override
  public ClassLoaderConfiguration load(File artifactFile, Map<String, Object> attributes, ArtifactType artifactType)
      throws InvalidDescriptorLoaderException {
    for (ClassLoaderConfigurationLoader ClassLoaderConfigurationLoader : ClassLoaderConfigurationLoaders) {
      if (ClassLoaderConfigurationLoader.supportsArtifactType(artifactType)) {
        return ClassLoaderConfigurationLoader.load(artifactFile, attributes, artifactType);
      }
    }
    throw new IllegalStateException(format("Artifact type %s not supported", artifactType));
  }

  @Override
  public boolean supportsArtifactType(ArtifactType artifactType) {
    return ClassLoaderConfigurationLoaders.stream()
        .anyMatch(ClassLoaderConfigurationLoader -> ClassLoaderConfigurationLoader.supportsArtifactType(artifactType));
  }
}
