/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.maven;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.file.Files;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.mule.extension.maven.documentation.DocumentationGenerator;
import org.mule.plugin.maven.AbstractMuleMojo;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.extension.api.persistence.ExtensionModelJsonSerializer;

@Mojo(name="documentation", defaultPhase=LifecyclePhase.VERIFY, requiresDependencyResolution=ResolutionScope.TEST, threadSafe=true)
public class ExtensionDocumentationMojo
extends AbstractMuleMojo {
    private static final String DOC_SUFFIX = "-documentation";
    @Parameter(defaultValue="${project.build.directory}/docs", required=true)
    private File outputDir;
    @Parameter(defaultValue="false", property="skipDocumentation")
    private Boolean skipDocumentation;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.disableExtensionModelFileGeneration.booleanValue() || this.skipDocumentation.booleanValue()) {
            this.getLog().info((CharSequence)"Extension Documentation generation skipped.");
            return;
        }
        if (!this.outputDir.exists()) {
            this.outputDir.mkdirs();
        }
        ExtensionModel extension = this.getExtensionModel();
        DocumentationGenerator documentationGenerator = new DocumentationGenerator(extension, this.buildDirectory);
        String asciidoc = documentationGenerator.generateAsciidoc(extension);
        String html = documentationGenerator.generateHtml(asciidoc);
        this.generateFile(this.getSanitizedName(extension) + "-documentation.adoc", asciidoc);
        this.generateFile(this.getSanitizedName(extension) + "-documentation.html", html);
    }

    private ExtensionModel getExtensionModel() throws MojoExecutionException {
        File generatedExtensionModelFile = new File(this.buildDirectory, "temporal-extension-model.json");
        try {
            String serializedExModel = new String(Files.readAllBytes(generatedExtensionModelFile.toPath()));
            return new ExtensionModelJsonSerializer(true).deserialize(serializedExModel);
        }
        catch (IOException e) {
            throw new MojoExecutionException(String.format("Cannot obtain/read the file [%s] to deserialize the ExtensionModel", generatedExtensionModelFile.getAbsolutePath()), (Exception)e);
        }
    }

    private String getSanitizedName(ExtensionModel extensionModel) {
        return extensionModel.getName().toLowerCase().replace(" ", "-");
    }

    private void generateFile(String fileName, String content) throws MojoExecutionException {
        File file = new File(this.outputDir, fileName);
        try {
            PrintWriter printWriter = new PrintWriter(file);
            printWriter.print(content);
            printWriter.close();
        }
        catch (FileNotFoundException e) {
            throw new MojoExecutionException(String.format("Cannot write the file [%s] (it does not exist), cannot generate documentation", file.getAbsolutePath()), (Exception)e);
        }
        this.getLog().info((CharSequence)String.format("Generated file [%s]", file.getAbsolutePath()));
    }
}

