/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extensions.maven.shade;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import org.apache.commons.io.IOUtils;
import org.apache.maven.plugins.shade.mojo.PackageRelocation;
import org.apache.maven.plugins.shade.relocation.Relocator;
import org.apache.maven.plugins.shade.resource.ReproducibleResourceTransformer;
import org.codehaus.plexus.util.IOUtil;
import org.mule.extensions.maven.shade.ExtensionShadingUtils;

public class MuleArtifactDescriptorTransformer
implements ReproducibleResourceTransformer {
    private static final String ARTIFACT_JSON_PATH = "META-INF/mule-artifact/mule-artifact.json";
    private long time = Long.MIN_VALUE;
    private final List<PackageRelocation> relocations;
    private String shadedArtifactJson;

    public MuleArtifactDescriptorTransformer(List<PackageRelocation> relocations) {
        this.relocations = relocations;
    }

    @Override
    public boolean canTransformResource(String resource) {
        return ARTIFACT_JSON_PATH.equals(resource);
    }

    @Override
    public void processResource(String resource, InputStream is, List<Relocator> relocators) throws IOException {
        this.processResource(resource, is, relocators, this.time);
    }

    @Override
    public void processResource(String resource, InputStream is, List<Relocator> relocators, long time) throws IOException {
        this.shadedArtifactJson = ExtensionShadingUtils.shadeClassNames(IOUtils.toString((InputStream)is, (Charset)Charset.defaultCharset()), this.relocations);
        if (time > this.time) {
            this.time = time;
        }
    }

    @Override
    public boolean hasTransformedResource() {
        return true;
    }

    @Override
    public void modifyOutputStream(JarOutputStream os) throws IOException {
        JarEntry entry = new JarEntry(ARTIFACT_JSON_PATH);
        entry.setTime(this.time);
        os.putNextEntry(entry);
        IOUtil.copy((InputStream)new ByteArrayInputStream(this.shadedArtifactJson.getBytes()), (OutputStream)os);
    }
}

