package org.apache.maven.plugins.shade.mojo;

/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

import java.util.List;

/**
 * @author Jason van Zyl
 * @author Mauro Talevi
 */
public class PackageRelocation {

  private String pattern;

  private String shadedPattern;

  private List<String> includes;

  private List<String> excludes;

  private boolean rawString;

  public String getPattern() {
    return pattern;
  }

  public String getShadedPattern() {
    return shadedPattern;
  }

  public List<String> getIncludes() {
    return includes;
  }

  public List<String> getExcludes() {
    return excludes;
  }

  public boolean isRawString() {
    return rawString;
  }

  public void setPattern(String pattern) {
    this.pattern = pattern;
  }

  public void setShadedPattern(String shadedPattern) {
    this.shadedPattern = shadedPattern;
  }

  public void setIncludes(List<String> includes) {
    this.includes = includes;
  }

  public void setExcludes(List<String> excludes) {
    this.excludes = excludes;
  }

  public void setRawString(boolean rawString) {
    this.rawString = rawString;
  }
}
