/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extensions.maven.shade;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.plugins.shade.mojo.PackageRelocation;
import org.apache.maven.plugins.shade.mojo.ShadeMojo;
import org.apache.maven.plugins.shade.resource.ResourceTransformer;
import org.mule.extensions.maven.shade.ExtensionShadingUtils;
import org.mule.extensions.maven.shade.MuleArtifactDescriptorTransformer;

@Mojo(name="shade", defaultPhase=LifecyclePhase.PACKAGE, threadSafe=true, requiresDependencyResolution=ResolutionScope.RUNTIME)
public class ExtensionShadeMojo
extends ShadeMojo {
    @Override
    public void execute() throws MojoExecutionException {
        File originalArtifactFile = this.project.getArtifact().getFile();
        File rootDirectory = originalArtifactFile.getParentFile();
        List<PackageRelocation> relocations = this.getRelocations();
        if (originalArtifactFile.isDirectory()) {
            String[] pluginFileNames = rootDirectory.list(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name.startsWith(ExtensionShadeMojo.this.project.getArtifactId()) && name.endsWith("-mule-plugin.jar");
                }
            });
            if (pluginFileNames.length > 0) {
                this.project.getArtifact().setFile(new File(rootDirectory, pluginFileNames[0]));
            }
            this.shadeTempFile(rootDirectory, "temporal-extension-model.json", relocations);
            this.shadeTempFile(rootDirectory, "classes/META-INF/mule-artifact/mule-artifact.json", relocations);
        }
        if (this.transformers != null) {
            ResourceTransformer[] enhancedTransformers = new ResourceTransformer[this.transformers.length + 1];
            System.arraycopy(this.transformers, 0, enhancedTransformers, 0, this.transformers.length);
            enhancedTransformers[this.transformers.length] = new MuleArtifactDescriptorTransformer(relocations);
            this.transformers = enhancedTransformers;
        } else {
            this.transformers = new ResourceTransformer[1];
            this.transformers[0] = new MuleArtifactDescriptorTransformer(relocations);
        }
        super.execute();
        this.project.getArtifact().setFile(originalArtifactFile);
    }

    private void shadeTempFile(File rootDirectory, String filePath, List<PackageRelocation> relocations) {
        String tempFileContent;
        File tempFile = Paths.get(rootDirectory.toString(), filePath).toFile();
        if (!tempFile.exists()) {
            this.getLog().warn((CharSequence)String.format("Couldn't find temporal file at '%s'. Will not shade it", tempFile.getAbsolutePath()));
            return;
        }
        try {
            tempFileContent = FileUtils.readFileToString((File)tempFile, (Charset)Charset.defaultCharset());
        }
        catch (IOException e) {
            this.getLog().warn((CharSequence)String.format("Couldn't read temp file at '%s'. Will not shade it", tempFile.getAbsolutePath()), (Throwable)e);
            return;
        }
        try {
            FileUtils.writeStringToFile((File)tempFile, (String)ExtensionShadingUtils.shadeClassNames(tempFileContent, relocations), (Charset)Charset.defaultCharset(), (boolean)false);
        }
        catch (IOException e) {
            this.getLog().warn((CharSequence)String.format("Couldn't overwrite shaded temp file at '%s'. Will not shade it", tempFile.getAbsolutePath()), (Throwable)e);
        }
    }

    private List<PackageRelocation> getRelocations() {
        if (this.relocations != null) {
            return Collections.unmodifiableList(Arrays.asList(this.relocations));
        }
        return Collections.emptyList();
    }
}

