/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.extensions.maven.shade;

import java.util.List;

import org.apache.maven.plugins.shade.mojo.PackageRelocation;

public final class ExtensionShadingUtils {

  private ExtensionShadingUtils() {}

  public static String shadeClassNames(String content, List<PackageRelocation> relocations) {
    for (PackageRelocation relocation : relocations) {
      String pattern = relocation.getPattern() + ".";
      String shade = relocation.getShadedPattern() + ".";
      content = content.replaceAll(pattern, shade);
    }

    return content;
  }
}
