/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.extensions.maven.shade;

import java.util.List;

import org.apache.maven.plugins.shade.mojo.PackageRelocation;

public final class ExtensionShadingUtils {

  private ExtensionShadingUtils() {}

  public static String shadeClassNames(String content, List<PackageRelocation> relocations) {
    for (PackageRelocation relocation : relocations) {
      String pattern = relocation.getPattern() + ".";
      String shade = relocation.getShadedPattern() + ".";

      // MMP-597: The idea behind this code is to try to avoid shading a content that has already been shaded previously
      if (content.contains(shade) && content.contains(pattern)) { // Possibly been shaded before or just coincidence?
        if (shade.contains(pattern)) { // Because pattern is a substring of shade pattern, content has most likely already been shaded
          continue;
        } else {
          // Either the shade pattern is a substring of pattern (this is why both were found in the content), or
          // there is no substring relation between patterns (so finding both was just a coincidence). In both cases,
          // we shade the content
          content = content.replaceAll(pattern, shade);
        }
      } else { // Shade normally
        content = content.replaceAll(pattern, shade);
      }
    }

    return content;
  }
}
