/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.shade;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;
import java.util.zip.CRC32;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.shade.DefaultShader;
import org.apache.maven.plugins.shade.ShadeRequest;
import org.apache.maven.plugins.shade.relocation.SimpleRelocator;
import org.apache.maven.plugins.shade.resource.AppendingTransformer;
import org.apache.maven.plugins.shade.resource.ComponentsXmlResourceTransformer;
import org.codehaus.plexus.logging.AbstractLogger;
import org.codehaus.plexus.logging.Logger;
import org.codehaus.plexus.logging.console.ConsoleLogger;
import org.codehaus.plexus.util.IOUtil;
import org.junit.Assert;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;

public class DefaultShaderTest {
    private static final String[] EXCLUDES = new String[]{"org/codehaus/plexus/util/xml/Xpp3Dom", "org/codehaus/plexus/util/xml/pull.*"};

    @Test
    public void testOverlappingResourcesAreLogged() throws IOException, MojoExecutionException {
        DefaultShader shader = new DefaultShader();
        MockLogger logs = new MockLogger();
        shader.enableLogging((Logger)logs);
        LinkedHashSet<File> set = new LinkedHashSet<File>();
        set.add(new File("src/test/jars/test-project-1.0-SNAPSHOT.jar"));
        set.add(new File("src/test/jars/plexus-utils-1.4.1.jar"));
        ShadeRequest shadeRequest = new ShadeRequest();
        shadeRequest.setJars(set);
        shadeRequest.setRelocators(Collections.emptyList());
        shadeRequest.setResourceTransformers(Collections.emptyList());
        shadeRequest.setFilters(Collections.emptyList());
        shadeRequest.setUberJar(new File("target/foo-custom_testOverlappingResourcesAreLogged.jar"));
        shader.shade(shadeRequest);
        String failureWarnMessage = logs.warnMessages.toString();
        Assert.assertTrue((String)failureWarnMessage, (boolean)logs.warnMessages.contains("plexus-utils-1.4.1.jar, test-project-1.0-SNAPSHOT.jar define 1 overlapping resource:"));
        Assert.assertTrue((String)failureWarnMessage, (boolean)logs.warnMessages.contains("- META-INF/MANIFEST.MF"));
        String failureDebugMessage = logs.debugMessages.toString();
        Assert.assertTrue((String)failureDebugMessage, (boolean)logs.debugMessages.contains("We have a duplicate META-INF/MANIFEST.MF in src/test/jars/plexus-utils-1.4.1.jar"));
    }

    @Test
    public void testOverlappingResourcesAreLoggedExceptATransformerHandlesIt() throws Exception {
        TemporaryFolder temporaryFolder = new TemporaryFolder();
        LinkedHashSet<File> set = new LinkedHashSet<File>();
        temporaryFolder.create();
        File j1 = temporaryFolder.newFile("j1.jar");
        try (JarOutputStream jos = new JarOutputStream(new FileOutputStream(j1));){
            jos.putNextEntry(new JarEntry("foo.txt"));
            jos.write("c1".getBytes(StandardCharsets.UTF_8));
            jos.closeEntry();
        }
        File j2 = temporaryFolder.newFile("j2.jar");
        try (JarOutputStream jos = new JarOutputStream(new FileOutputStream(j2));){
            jos.putNextEntry(new JarEntry("foo.txt"));
            jos.write("c2".getBytes(StandardCharsets.UTF_8));
            jos.closeEntry();
        }
        set.add(j1);
        set.add(j2);
        AppendingTransformer transformer = new AppendingTransformer();
        Field resource = AppendingTransformer.class.getDeclaredField("resource");
        resource.setAccessible(true);
        resource.set(transformer, "foo.txt");
        ShadeRequest shadeRequest = new ShadeRequest();
        shadeRequest.setJars(set);
        shadeRequest.setRelocators(Collections.emptyList());
        shadeRequest.setResourceTransformers(Collections.singletonList(transformer));
        shadeRequest.setFilters(Collections.emptyList());
        shadeRequest.setUberJar(new File("target/foo-custom_testOverlappingResourcesAreLogged.jar"));
        DefaultShader shaderWithTransformer = new DefaultShader();
        MockLogger logWithTransformer = new MockLogger();
        shaderWithTransformer.enableLogging((Logger)logWithTransformer);
        shaderWithTransformer.shade(shadeRequest);
        DefaultShader shaderWithoutTransformer = new DefaultShader();
        MockLogger logWithoutTransformer = new MockLogger();
        shaderWithoutTransformer.enableLogging((Logger)logWithoutTransformer);
        shadeRequest.setResourceTransformers(Collections.emptyList());
        shaderWithoutTransformer.shade(shadeRequest);
        temporaryFolder.delete();
        Assert.assertTrue((String)logWithTransformer.warnMessages.toString(), (boolean)logWithTransformer.warnMessages.isEmpty());
        Assert.assertTrue((String)logWithoutTransformer.warnMessages.toString(), (boolean)logWithoutTransformer.warnMessages.containsAll(Arrays.asList("j1.jar, j2.jar define 1 overlapping resource:", "- foo.txt")));
    }

    @Test
    public void testShaderWithDefaultShadedPattern() throws Exception {
        this.shaderWithPattern(null, new File("target/foo-default.jar"), EXCLUDES);
    }

    @Test
    public void testShaderWithStaticInitializedClass() throws Exception {
        DefaultShader s = DefaultShaderTest.newShader();
        LinkedHashSet<File> set = new LinkedHashSet<File>();
        set.add(new File("src/test/jars/test-artifact-1.0-SNAPSHOT.jar"));
        ArrayList<SimpleRelocator> relocators = new ArrayList<SimpleRelocator>();
        relocators.add(new SimpleRelocator("org.apache.maven.plugins.shade", null, null, null));
        ArrayList resourceTransformers = new ArrayList();
        ArrayList filters = new ArrayList();
        File file = new File("target/testShaderWithStaticInitializedClass.jar");
        ShadeRequest shadeRequest = new ShadeRequest();
        shadeRequest.setJars(set);
        shadeRequest.setUberJar(file);
        shadeRequest.setFilters(filters);
        shadeRequest.setRelocators(relocators);
        shadeRequest.setResourceTransformers(resourceTransformers);
        s.shade(shadeRequest);
        try (URLClassLoader cl = new URLClassLoader(new URL[]{file.toURI().toURL()});){
            Class<?> c = cl.loadClass("hidden.org.apache.maven.plugins.shade.Lib");
            Object o = c.newInstance();
            Assert.assertEquals((Object)"foo.bar/baz", (Object)c.getDeclaredField("CONSTANT").get(o));
        }
    }

    @Test
    public void testShaderWithCustomShadedPattern() throws Exception {
        this.shaderWithPattern("org/shaded/plexus/util", new File("target/foo-custom.jar"), EXCLUDES);
    }

    @Test
    public void testShaderWithoutExcludesShouldRemoveReferencesOfOriginalPattern() throws Exception {
        this.shaderWithPattern("org/shaded/plexus/util", new File("target/foo-custom-without-excludes.jar"), new String[0]);
    }

    @Test
    public void testShaderWithRelocatedClassname() throws Exception {
        DefaultShader s = DefaultShaderTest.newShader();
        LinkedHashSet<File> set = new LinkedHashSet<File>();
        set.add(new File("src/test/jars/test-project-1.0-SNAPSHOT.jar"));
        set.add(new File("src/test/jars/plexus-utils-1.4.1.jar"));
        ArrayList<SimpleRelocator> relocators = new ArrayList<SimpleRelocator>();
        relocators.add(new SimpleRelocator("org/codehaus/plexus/util/", "_plexus/util/__", null, Collections.emptyList()));
        ArrayList<ComponentsXmlResourceTransformer> resourceTransformers = new ArrayList<ComponentsXmlResourceTransformer>();
        resourceTransformers.add(new ComponentsXmlResourceTransformer());
        ArrayList filters = new ArrayList();
        File file = new File("target/foo-relocate-class.jar");
        ShadeRequest shadeRequest = new ShadeRequest();
        shadeRequest.setJars(set);
        shadeRequest.setUberJar(file);
        shadeRequest.setFilters(filters);
        shadeRequest.setRelocators(relocators);
        shadeRequest.setResourceTransformers(resourceTransformers);
        s.shade(shadeRequest);
        try (URLClassLoader cl = new URLClassLoader(new URL[]{file.toURI().toURL()});){
            Class<?> c = cl.loadClass("_plexus.util.__StringUtils");
            Object o = c.newInstance();
            Assert.assertEquals((Object)"", (Object)c.getMethod("clean", String.class).invoke(o, new Object[]{null}));
            final String[] source = new String[]{null};
            ClassReader classReader = new ClassReader(cl.getResourceAsStream("_plexus/util/__StringUtils.class"));
            classReader.accept(new ClassVisitor(262144){

                public void visitSource(String arg0, String arg1) {
                    super.visitSource(arg0, arg1);
                    source[0] = arg0;
                }
            }, 1);
            Assert.assertEquals((Object)"__StringUtils.java", (Object)source[0]);
        }
    }

    @Test
    public void testShaderWithNestedJar() throws Exception {
        TemporaryFolder temporaryFolder = new TemporaryFolder();
        String innerJarFileName = "inner.jar";
        temporaryFolder.create();
        File innerJar = temporaryFolder.newFile("inner.jar");
        try (JarOutputStream jos = new JarOutputStream(new FileOutputStream(innerJar));){
            jos.putNextEntry(new JarEntry("foo.txt"));
            jos.write("c1".getBytes(StandardCharsets.UTF_8));
            jos.closeEntry();
        }
        File outerJar = temporaryFolder.newFile("outer.jar");
        try (JarOutputStream jos = new JarOutputStream(new FileOutputStream(outerJar));){
            FileInputStream innerStream = new FileInputStream(innerJar);
            byte[] bytes = IOUtil.toByteArray((InputStream)innerStream, (int)32768);
            innerStream.close();
            this.writeEntryWithoutCompression("inner.jar", bytes, jos);
        }
        ShadeRequest shadeRequest = new ShadeRequest();
        shadeRequest.setJars(new LinkedHashSet<File>(Collections.singleton(outerJar)));
        shadeRequest.setFilters(new ArrayList());
        shadeRequest.setRelocators(new ArrayList());
        shadeRequest.setResourceTransformers(new ArrayList());
        File shadedFile = temporaryFolder.newFile("shaded.jar");
        shadeRequest.setUberJar(shadedFile);
        DefaultShader shader = DefaultShaderTest.newShader();
        shader.shade(shadeRequest);
        JarFile shadedJarFile = new JarFile(shadedFile);
        JarEntry entry = shadedJarFile.getJarEntry("inner.jar");
        Assert.assertEquals((long)entry.getMethod(), (long)0L);
        temporaryFolder.delete();
    }

    private void writeEntryWithoutCompression(String entryName, byte[] entryBytes, JarOutputStream jos) throws IOException {
        JarEntry entry = new JarEntry(entryName);
        int size = entryBytes.length;
        CRC32 crc = new CRC32();
        crc.update(entryBytes, 0, size);
        entry.setSize(size);
        entry.setCompressedSize(size);
        entry.setMethod(0);
        entry.setCrc(crc.getValue());
        jos.putNextEntry(entry);
        jos.write(entryBytes);
        jos.closeEntry();
    }

    private void shaderWithPattern(String shadedPattern, File jar, String[] excludes) throws Exception {
        DefaultShader s = DefaultShaderTest.newShader();
        LinkedHashSet<File> set = new LinkedHashSet<File>();
        set.add(new File("src/test/jars/test-project-1.0-SNAPSHOT.jar"));
        set.add(new File("src/test/jars/plexus-utils-1.4.1.jar"));
        ArrayList<SimpleRelocator> relocators = new ArrayList<SimpleRelocator>();
        relocators.add(new SimpleRelocator("org/codehaus/plexus/util", shadedPattern, null, Arrays.asList(excludes)));
        ArrayList<ComponentsXmlResourceTransformer> resourceTransformers = new ArrayList<ComponentsXmlResourceTransformer>();
        resourceTransformers.add(new ComponentsXmlResourceTransformer());
        ArrayList filters = new ArrayList();
        ShadeRequest shadeRequest = new ShadeRequest();
        shadeRequest.setJars(set);
        shadeRequest.setUberJar(jar);
        shadeRequest.setFilters(filters);
        shadeRequest.setRelocators(relocators);
        shadeRequest.setResourceTransformers(resourceTransformers);
        s.shade(shadeRequest);
    }

    private static DefaultShader newShader() {
        DefaultShader s = new DefaultShader();
        s.enableLogging((Logger)new ConsoleLogger(1, "TEST"));
        return s;
    }

    private static class MockLogger
    extends AbstractLogger {
        private final List<String> debugMessages = new ArrayList<String>();
        private final List<String> warnMessages = new ArrayList<String>();

        private MockLogger() {
            super(1, "test");
        }

        public void debug(String s, Throwable throwable) {
            this.debugMessages.add(s.replace('\\', '/').trim());
        }

        public void info(String s, Throwable throwable) {
        }

        public void warn(String s, Throwable throwable) {
            this.warnMessages.add(s.replace('\\', '/').trim());
        }

        public void error(String s, Throwable throwable) {
        }

        public void fatalError(String s, Throwable throwable) {
        }

        public Logger getChildLogger(String s) {
            return this;
        }
    }
}

