/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.shade.mojo;

import java.io.File;
import java.io.IOException;
import org.apache.maven.plugins.shade.mojo.RelativizePath;
import org.junit.Assert;
import org.junit.Test;

public class RelativizePathTest {
    static final String[] PARENTS = new String[]{"rel-path-test-files/a/pom", "rel-path-test-files/a/b/pom", "rel-path-test-files/a/b/c/pom", "rel-path-test-files/a/c/d/pom"};
    static final String[] CHILDREN = new String[]{"rel-path-test-files/a/b/pom", "rel-path-test-files/a/pom", "rel-path-test-files/a/b/c1/pom", "rel-path-test-files/a/c/d/pom"};
    static final String[] ANSWER = new String[]{"../pom", "b/pom", "../c/pom", "pom"};

    @Test
    public void runTests() throws IOException {
        for (int x = 0; x < PARENTS.length; ++x) {
            File parent = new File(PARENTS[x]).getCanonicalFile();
            File child = new File(CHILDREN[x]).getCanonicalFile();
            String answer = ANSWER[x];
            String r = RelativizePath.convertToRelativePath((File)parent, (File)child);
            Assert.assertEquals((String)String.format("parent %s child %s", parent.toString(), child.toString()), (Object)answer, (Object)r);
        }
    }
}

