/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.shade.mojo;

import org.apache.maven.plugins.shade.mojo.ArtifactId;
import org.junit.Assert;
import org.junit.Test;

public class ArtifactIdTest {
    @Test
    public void testIdParsing() {
        ArtifactId id = new ArtifactId((String)null);
        Assert.assertEquals((Object)"", (Object)id.getGroupId());
        id = new ArtifactId("");
        Assert.assertEquals((Object)"", (Object)id.getGroupId());
        id = new ArtifactId("gid");
        Assert.assertEquals((Object)"gid", (Object)id.getGroupId());
        Assert.assertEquals((Object)"*", (Object)id.getArtifactId());
        Assert.assertEquals((Object)"*", (Object)id.getType());
        Assert.assertEquals((Object)"*", (Object)id.getClassifier());
        id = new ArtifactId("gid:");
        Assert.assertEquals((Object)"gid", (Object)id.getGroupId());
        Assert.assertEquals((Object)"", (Object)id.getArtifactId());
        Assert.assertEquals((Object)"*", (Object)id.getType());
        Assert.assertEquals((Object)"*", (Object)id.getClassifier());
        id = new ArtifactId(":aid");
        Assert.assertEquals((Object)"", (Object)id.getGroupId());
        Assert.assertEquals((Object)"aid", (Object)id.getArtifactId());
        Assert.assertEquals((Object)"*", (Object)id.getType());
        Assert.assertEquals((Object)"*", (Object)id.getClassifier());
        id = new ArtifactId("gid:aid");
        Assert.assertEquals((Object)"gid", (Object)id.getGroupId());
        Assert.assertEquals((Object)"aid", (Object)id.getArtifactId());
        Assert.assertEquals((Object)"*", (Object)id.getType());
        Assert.assertEquals((Object)"*", (Object)id.getClassifier());
        id = new ArtifactId("gid:aid:");
        Assert.assertEquals((Object)"gid", (Object)id.getGroupId());
        Assert.assertEquals((Object)"aid", (Object)id.getArtifactId());
        Assert.assertEquals((Object)"*", (Object)id.getType());
        Assert.assertEquals((Object)"", (Object)id.getClassifier());
        id = new ArtifactId("gid:aid:cls");
        Assert.assertEquals((Object)"gid", (Object)id.getGroupId());
        Assert.assertEquals((Object)"aid", (Object)id.getArtifactId());
        Assert.assertEquals((Object)"*", (Object)id.getType());
        Assert.assertEquals((Object)"cls", (Object)id.getClassifier());
        id = new ArtifactId("gid:aid:type:cls");
        Assert.assertEquals((Object)"gid", (Object)id.getGroupId());
        Assert.assertEquals((Object)"aid", (Object)id.getArtifactId());
        Assert.assertEquals((Object)"type", (Object)id.getType());
        Assert.assertEquals((Object)"cls", (Object)id.getClassifier());
        id = new ArtifactId("gid:aid::cls");
        Assert.assertEquals((Object)"gid", (Object)id.getGroupId());
        Assert.assertEquals((Object)"aid", (Object)id.getArtifactId());
        Assert.assertEquals((Object)"", (Object)id.getType());
        Assert.assertEquals((Object)"cls", (Object)id.getClassifier());
        id = new ArtifactId("gid:aid::");
        Assert.assertEquals((Object)"gid", (Object)id.getGroupId());
        Assert.assertEquals((Object)"aid", (Object)id.getArtifactId());
        Assert.assertEquals((Object)"", (Object)id.getType());
        Assert.assertEquals((Object)"", (Object)id.getClassifier());
        id = new ArtifactId("*:aid:type:cls");
        Assert.assertEquals((Object)"*", (Object)id.getGroupId());
        Assert.assertEquals((Object)"aid", (Object)id.getArtifactId());
        Assert.assertEquals((Object)"type", (Object)id.getType());
        Assert.assertEquals((Object)"cls", (Object)id.getClassifier());
        id = new ArtifactId("gid:*:type:cls");
        Assert.assertEquals((Object)"gid", (Object)id.getGroupId());
        Assert.assertEquals((Object)"*", (Object)id.getArtifactId());
        Assert.assertEquals((Object)"type", (Object)id.getType());
        Assert.assertEquals((Object)"cls", (Object)id.getClassifier());
        id = new ArtifactId("gid:aid:*:cls");
        Assert.assertEquals((Object)"gid", (Object)id.getGroupId());
        Assert.assertEquals((Object)"aid", (Object)id.getArtifactId());
        Assert.assertEquals((Object)"*", (Object)id.getType());
        Assert.assertEquals((Object)"cls", (Object)id.getClassifier());
        id = new ArtifactId("gid:aid:type:*");
        Assert.assertEquals((Object)"gid", (Object)id.getGroupId());
        Assert.assertEquals((Object)"aid", (Object)id.getArtifactId());
        Assert.assertEquals((Object)"type", (Object)id.getType());
        Assert.assertEquals((Object)"*", (Object)id.getClassifier());
    }

    @Test
    public void testMatches() {
        Assert.assertTrue((boolean)new ArtifactId("gid", "aid", "type", "cls").matches(new ArtifactId("gid:aid:type:cls")));
        Assert.assertFalse((boolean)new ArtifactId("Gid", "aid", "type", "cls").matches(new ArtifactId("gid:aid:type:cls")));
        Assert.assertFalse((boolean)new ArtifactId("gid", "Aid", "type", "cls").matches(new ArtifactId("gid:aid:type:cls")));
        Assert.assertFalse((boolean)new ArtifactId("gid", "aid", "Type", "cls").matches(new ArtifactId("gid:aid:type:cls")));
        Assert.assertFalse((boolean)new ArtifactId("gid", "aid", "type", "Cls").matches(new ArtifactId("gid:aid:type:cls")));
        Assert.assertTrue((boolean)new ArtifactId("gid", "aid", "any", "cls").matches(new ArtifactId("gid:aid:cls")));
        Assert.assertTrue((boolean)new ArtifactId("gid", "aid", "type", "cls").matches(new ArtifactId("gid:aid:cls")));
        Assert.assertFalse((boolean)new ArtifactId("id", "aid", "type", "cls").matches(new ArtifactId("gid:aid:cls")));
        Assert.assertFalse((boolean)new ArtifactId("gid", "id", "type", "cls").matches(new ArtifactId("gid:aid:cls")));
        Assert.assertFalse((boolean)new ArtifactId("gid", "id", "type", "ls").matches(new ArtifactId("gid:aid:cls")));
        Assert.assertTrue((boolean)new ArtifactId("gid", "aid", "type", "").matches(new ArtifactId("gid:aid")));
        Assert.assertTrue((boolean)new ArtifactId("gid", "aid", "any", "tests").matches(new ArtifactId("gid:aid")));
        Assert.assertFalse((boolean)new ArtifactId("id", "aid", "type", "").matches(new ArtifactId("gid:aid")));
        Assert.assertFalse((boolean)new ArtifactId("gid", "id", "type", "").matches(new ArtifactId("gid:aid")));
        Assert.assertTrue((boolean)new ArtifactId("gid", "aid", "type", "").matches(new ArtifactId("gid")));
        Assert.assertTrue((boolean)new ArtifactId("gid", "id", "any", "any").matches(new ArtifactId("gid")));
        Assert.assertFalse((boolean)new ArtifactId("id", "aid", "type", "").matches(new ArtifactId("gid")));
        Assert.assertTrue((boolean)new ArtifactId("gid", "aid", "type", "cls").matches(new ArtifactId("*:aid:type:cls")));
        Assert.assertTrue((boolean)new ArtifactId("any", "aid", "type", "cls").matches(new ArtifactId("*:aid:type:cls")));
        Assert.assertFalse((boolean)new ArtifactId("any", "id", "type", "cls").matches(new ArtifactId("*:aid:type:cls")));
        Assert.assertTrue((boolean)new ArtifactId("gid", "aid", "type", "cls").matches(new ArtifactId("gid:*:type:cls")));
        Assert.assertTrue((boolean)new ArtifactId("gid", "any", "type", "cls").matches(new ArtifactId("gid:*:type:cls")));
        Assert.assertFalse((boolean)new ArtifactId("id", "any", "type", "cls").matches(new ArtifactId("gid:*:type:cls")));
        Assert.assertTrue((boolean)new ArtifactId("gid", "aid", "type", "cls").matches(new ArtifactId("gid:aid:*:cls")));
        Assert.assertTrue((boolean)new ArtifactId("gid", "aid", "any", "cls").matches(new ArtifactId("gid:aid:*:cls")));
        Assert.assertFalse((boolean)new ArtifactId("id", "aid", "any", "cls").matches(new ArtifactId("gid:aid:*:cls")));
        Assert.assertTrue((boolean)new ArtifactId("gid", "aid", "type", "cls").matches(new ArtifactId("gid:aid:type:*")));
        Assert.assertTrue((boolean)new ArtifactId("gid", "aid", "type", "any").matches(new ArtifactId("gid:aid:type:*")));
        Assert.assertFalse((boolean)new ArtifactId("id", "aid", "type", "any").matches(new ArtifactId("gid:aid:type:*")));
        Assert.assertTrue((boolean)new ArtifactId("gid", "aid", "type", "cls").matches(new ArtifactId("gid:a*d")));
        Assert.assertTrue((boolean)new ArtifactId("gid", "ad", "type", "cls").matches(new ArtifactId("gid:a*d")));
        Assert.assertTrue((boolean)new ArtifactId("gid", "a---d", "type", "cls").matches(new ArtifactId("gid:a*d")));
        Assert.assertTrue((boolean)new ArtifactId("gid", "aid", "type", "cls").matches(new ArtifactId("gid:a?d")));
        Assert.assertTrue((boolean)new ArtifactId("gid", "a-d", "type", "cls").matches(new ArtifactId("gid:a?d")));
        Assert.assertFalse((boolean)new ArtifactId("gid", "ad", "type", "cls").matches(new ArtifactId("gid:a?d")));
        Assert.assertFalse((boolean)new ArtifactId("gid", "a---d", "type", "cls").matches(new ArtifactId("gid:a?d")));
    }
}

