/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.shade.resource;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.util.Collections;
import java.util.Properties;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;
import java.util.zip.ZipEntry;
import org.apache.maven.plugins.shade.resource.GroovyResourceTransformer;
import org.junit.Assert;
import org.junit.Test;

public class GroovyResourceTransformerTest {
    private static InputStream stream(Properties props) throws Exception {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        props.store(baos, null);
        return new ByteArrayInputStream(baos.toByteArray());
    }

    private static InputStream module(String name, String version, String extensionClasses, String staticExtensionClasses) throws Exception {
        Properties desc = new Properties();
        desc.setProperty("moduleName", name);
        desc.setProperty("moduleVersion", version);
        if (extensionClasses != null) {
            desc.setProperty("extensionClasses", extensionClasses);
        }
        if (staticExtensionClasses != null) {
            desc.setProperty("staticExtensionClasses", staticExtensionClasses);
        }
        return GroovyResourceTransformerTest.stream(desc);
    }

    private static Properties transform(GroovyResourceTransformer transformer) throws Exception {
        File tempJar = File.createTempFile("shade.", ".jar");
        tempJar.deleteOnExit();
        try (FileOutputStream fos = new FileOutputStream(tempJar);
             JarOutputStream jaos = new JarOutputStream(fos);){
            transformer.modifyOutputStream(jaos);
        }
        Properties desc = null;
        try (JarFile jar = new JarFile(tempJar);){
            ZipEntry entry = jar.getEntry("META-INF/groovy/org.codehaus.groovy.runtime.ExtensionModule");
            if (entry != null) {
                desc = new Properties();
                desc.load(jar.getInputStream(entry));
            }
        }
        return desc;
    }

    @Test
    public void testFilter() {
        GroovyResourceTransformer transformer = new GroovyResourceTransformer();
        Assert.assertTrue((boolean)transformer.canTransformResource("META-INF/groovy/org.codehaus.groovy.runtime.ExtensionModule"));
        Assert.assertTrue((boolean)transformer.canTransformResource("META-INF/services/org.codehaus.groovy.runtime.ExtensionModule"));
        Assert.assertFalse((boolean)transformer.canTransformResource("somethingElse"));
        Assert.assertFalse((boolean)transformer.canTransformResource("META-INF/MANIFEST.MF"));
    }

    @Test
    public void testEmpty() throws Exception {
        GroovyResourceTransformer transformer = new GroovyResourceTransformer();
        Assert.assertFalse((boolean)transformer.hasTransformedResource());
        Assert.assertNull((Object)GroovyResourceTransformerTest.transform(transformer));
    }

    @Test
    public void testSpecifyModuleName() throws Exception {
        GroovyResourceTransformer transformer = new GroovyResourceTransformer();
        transformer.setExtModuleName("the-module-name");
        transformer.setExtModuleVersion("2.0");
        transformer.processResource("META-INF/groovy/org.codehaus.groovy.runtime.ExtensionModule", GroovyResourceTransformerTest.module("mod1", "1.0", "some.ext", "some.staticExt"), Collections.emptyList(), 0L);
        Properties desc = GroovyResourceTransformerTest.transform(transformer);
        Assert.assertEquals((Object)"the-module-name", (Object)desc.getProperty("moduleName"));
        Assert.assertEquals((Object)"2.0", (Object)desc.getProperty("moduleVersion"));
        Assert.assertEquals((Object)"some.ext", (Object)desc.getProperty("extensionClasses"));
        Assert.assertEquals((Object)"some.staticExt", (Object)desc.getProperty("staticExtensionClasses"));
    }

    @Test
    public void testConcatenation() throws Exception {
        GroovyResourceTransformer transformer = new GroovyResourceTransformer();
        transformer.processResource("META-INF/groovy/org.codehaus.groovy.runtime.ExtensionModule", GroovyResourceTransformerTest.module("mod1", "1.0", "some.ext1", null), Collections.emptyList(), 0L);
        transformer.processResource("META-INF/groovy/org.codehaus.groovy.runtime.ExtensionModule", GroovyResourceTransformerTest.module("mod2", "1.0", null, "some.staticExt1"), Collections.emptyList(), 0L);
        transformer.processResource("META-INF/groovy/org.codehaus.groovy.runtime.ExtensionModule", GroovyResourceTransformerTest.module("mod3", "1.0", "", ""), Collections.emptyList(), 0L);
        transformer.processResource("META-INF/groovy/org.codehaus.groovy.runtime.ExtensionModule", GroovyResourceTransformerTest.module("mod4", "1.0", "some.ext2", "some.staticExt2"), Collections.emptyList(), 0L);
        Properties desc = GroovyResourceTransformerTest.transform(transformer);
        Assert.assertEquals((Object)"no-module-name", (Object)desc.getProperty("moduleName"));
        Assert.assertEquals((Object)"1.0", (Object)desc.getProperty("moduleVersion"));
        Assert.assertEquals((Object)"some.ext1,some.ext2", (Object)desc.getProperty("extensionClasses"));
        Assert.assertEquals((Object)"some.staticExt1,some.staticExt2", (Object)desc.getProperty("staticExtensionClasses"));
    }
}

