/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.shade.resource;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.List;
import org.apache.maven.plugins.shade.resource.ApacheNoticeResourceTransformer;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ApacheNoticeResourceTransformerParameterTests {
    private static final String NOTICE_RESOURCE = "META-INF/NOTICE";
    private ApacheNoticeResourceTransformer subject;

    @Before
    public void setUp() {
        this.subject = new ApacheNoticeResourceTransformer();
    }

    @Test
    public void testNoParametersShouldNotThrowNullPointerWhenNoInput() throws IOException {
        this.processAndFailOnNullPointer("");
    }

    @Test
    public void testNoParametersShouldNotThrowNullPointerWhenNoLinesOfInput() throws IOException {
        this.processAndFailOnNullPointer("Some notice text");
    }

    @Test
    public void testNoParametersShouldNotThrowNullPointerWhenOneLineOfInput() throws IOException {
        this.processAndFailOnNullPointer("Some notice text\n");
    }

    @Test
    public void testNoParametersShouldNotThrowNullPointerWhenTwoLinesOfInput() throws IOException {
        this.processAndFailOnNullPointer("Some notice text\nSome notice text\n");
    }

    @Test
    public void testNoParametersShouldNotThrowNullPointerWhenLineStartsWithSlashSlash() throws IOException {
        this.processAndFailOnNullPointer("Some notice text\n//Some notice text\n");
    }

    @Test
    public void testNoParametersShouldNotThrowNullPointerWhenLineIsSlashSlash() throws IOException {
        this.processAndFailOnNullPointer("//\n");
    }

    @Test
    public void testNoParametersShouldNotThrowNullPointerWhenLineIsEmpty() throws IOException {
        this.processAndFailOnNullPointer("\n");
    }

    private void processAndFailOnNullPointer(String noticeText) throws IOException {
        try {
            ByteArrayInputStream noticeInputStream = new ByteArrayInputStream(noticeText.getBytes());
            List emptyList = Collections.emptyList();
            this.subject.processResource(NOTICE_RESOURCE, (InputStream)noticeInputStream, emptyList, 0L);
            noticeInputStream.close();
        }
        catch (NullPointerException e) {
            Assert.fail((String)"Null pointer should not be thrown when no parameters are set.");
        }
    }
}

