/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.shade.resource.rule;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.jar.JarOutputStream;
import org.apache.maven.plugins.shade.resource.ReproducibleResourceTransformer;
import org.codehaus.plexus.component.configurator.ComponentConfigurationException;
import org.codehaus.plexus.component.configurator.converters.ConfigurationConverter;
import org.codehaus.plexus.component.configurator.converters.lookup.ConverterLookup;
import org.codehaus.plexus.component.configurator.converters.lookup.DefaultConverterLookup;
import org.codehaus.plexus.component.configurator.expression.DefaultExpressionEvaluator;
import org.codehaus.plexus.component.configurator.expression.ExpressionEvaluator;
import org.codehaus.plexus.configuration.DefaultPlexusConfiguration;
import org.codehaus.plexus.configuration.PlexusConfiguration;
import org.junit.Assert;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

public class TransformerTesterRule
implements TestRule {
    public Statement apply(final Statement base, final Description description) {
        return new Statement(){

            public void evaluate() throws Throwable {
                Map jar;
                TransformerTest spec = (TransformerTest)description.getAnnotation(TransformerTest.class);
                if (spec == null) {
                    base.evaluate();
                    return;
                }
                try {
                    ReproducibleResourceTransformer transformer = TransformerTesterRule.this.createTransformer(spec);
                    TransformerTesterRule.this.visit(spec, transformer);
                    jar = TransformerTesterRule.this.captureOutput(transformer);
                }
                catch (Exception ex) {
                    if (Exception.class.isAssignableFrom(spec.expectedException())) {
                        Assert.assertTrue((String)ex.getClass().getName(), (boolean)spec.expectedException().isAssignableFrom(ex.getClass()));
                        return;
                    }
                    throw ex;
                }
                TransformerTesterRule.this.asserts(spec, jar);
            }
        };
    }

    private void asserts(TransformerTest spec, Map<String, String> jar) {
        if (spec.strictMatch() && jar.size() != spec.expected().length) {
            Assert.fail((String)("Strict match test failed: " + jar));
        }
        for (Resource expected : spec.expected()) {
            String content = jar.get(expected.path());
            Assert.assertNotNull((String)expected.path(), (Object)content);
            Assert.assertTrue((String)(expected.path() + ", expected=" + expected.content() + ", actual=" + content), (boolean)content.replace(System.lineSeparator(), "\n").matches(expected.content()));
        }
    }

    private Map<String, String> captureOutput(ReproducibleResourceTransformer transformer) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try (JarOutputStream jar = new JarOutputStream(out);){
            transformer.modifyOutputStream(jar);
        }
        HashMap<String, String> created = new HashMap<String, String>();
        try (JarInputStream jar = new JarInputStream(new ByteArrayInputStream(out.toByteArray()));){
            JarEntry entry;
            while ((entry = jar.getNextJarEntry()) != null) {
                created.put(entry.getName(), this.read(jar));
            }
        }
        return created;
    }

    private void visit(TransformerTest spec, ReproducibleResourceTransformer transformer) throws IOException {
        for (Resource resource : spec.visited()) {
            if (!transformer.canTransformResource(resource.path())) continue;
            transformer.processResource(resource.path(), new ByteArrayInputStream(resource.content().getBytes(StandardCharsets.UTF_8)), Collections.emptyList(), 0L);
        }
    }

    private String read(JarInputStream jar) throws IOException {
        int read;
        StringBuilder builder = new StringBuilder();
        byte[] buffer = new byte[512];
        while ((read = jar.read(buffer)) >= 0) {
            builder.append(new String(buffer, 0, read));
        }
        return builder.toString();
    }

    private ReproducibleResourceTransformer createTransformer(TransformerTest spec) {
        DefaultConverterLookup lookup = new DefaultConverterLookup();
        try {
            ConfigurationConverter converter = lookup.lookupConverterForType(spec.transformer());
            DefaultPlexusConfiguration configuration = new DefaultPlexusConfiguration("configuration");
            for (Property property : spec.configuration()) {
                configuration.addChild(property.name(), property.value());
            }
            return (ReproducibleResourceTransformer)ReproducibleResourceTransformer.class.cast(converter.fromConfiguration((ConverterLookup)lookup, (PlexusConfiguration)configuration, spec.transformer(), spec.transformer(), Thread.currentThread().getContextClassLoader(), (ExpressionEvaluator)new DefaultExpressionEvaluator()));
        }
        catch (ComponentConfigurationException e) {
            throw new IllegalStateException(e);
        }
    }

    @Target(value={ElementType.METHOD})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface Resource {
        public String path();

        public String content();
    }

    @Target(value={ElementType.METHOD})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface Property {
        public String name();

        public String value();
    }

    @Target(value={ElementType.METHOD})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface TransformerTest {
        public Resource[] visited();

        public Resource[] expected();

        public boolean strictMatch() default true;

        public Class<?> transformer();

        public Property[] configuration();

        public Class<?> expectedException() default Object.class;
    }
}

