/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.shade.resource;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.jar.Attributes;
import java.util.jar.JarInputStream;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import org.apache.maven.plugins.shade.relocation.Relocator;
import org.apache.maven.plugins.shade.relocation.SimpleRelocator;
import org.apache.maven.plugins.shade.resource.ManifestResourceTransformer;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ManifestResourceTransformerTest {
    private ManifestResourceTransformer transformer;

    @Before
    public void setUp() {
        this.transformer = new ManifestResourceTransformer();
    }

    @Test
    public void rewriteDefaultAttributes() throws Exception {
        Manifest manifest = new Manifest();
        Attributes attributes = manifest.getMainAttributes();
        attributes.put(Attributes.Name.MANIFEST_VERSION, "1.0");
        attributes.putValue("Export-Package", "javax.decorator;version=\"2.0\";uses:=\"javax.enterprise.inject\",javax.enterprise.context;version=\"2.0\";uses:=\"javax.enterprise.util,javax.inject\"");
        attributes.putValue("Import-Package", "javax.el,javax.enterprise.context;version=\"[2.0,3)\"");
        attributes.putValue("Provide-Capability", "osgi.contract;osgi.contract=JavaCDI;uses:=\"javax.enterprise.context,javax.enterprise.context.spi,javax.enterprise.context.control,javax.enterprise.util,javax.enterprise.inject,javax.enterprise.inject.spi,javax.enterprise.inject.spi.configurator,javax.enterprise.inject.literal,javax.enterprise.inject.se,javax.enterprise.event,javax.decorator\";version:List<Version>=\"2.0,1.2,1.1,1.0\"");
        attributes.putValue("Require-Capability", "osgi.serviceloader;filter:=\"(osgi.serviceloader=javax.enterprise.inject.se.SeContainerInitializer)\";cardinality:=multiple,osgi.serviceloader;filter:=\"(osgi.serviceloader=javax.enterprise.inject.spi.CDIProvider)\";cardinality:=multiple,osgi.extender;filter:=\"(osgi.extender=osgi.serviceloader.processor)\",osgi.contract;osgi.contract=JavaEL;filter:=\"(&(osgi.contract=JavaEL)(version=2.2.0))\",osgi.contract;osgi.contract=JavaInterceptor;filter:=\"(&(osgi.contract=JavaInterceptor)(version=1.2.0))\",osgi.contract;osgi.contract=JavaInject;filter:=\"(&(osgi.contract=JavaInject)(version=1.0.0))\",osgi.ee;filter:=\"(&(osgi.ee=JavaSE)(version=1.8))\"");
        List<SimpleRelocator> relocators = Collections.singletonList(new SimpleRelocator("javax", "jakarta", Collections.emptyList(), Collections.emptyList()));
        ByteArrayOutputStream out = this.transform(manifest, relocators);
        try (JarInputStream jis = new JarInputStream(new ByteArrayInputStream(out.toByteArray()));){
            Attributes attrs = jis.getManifest().getMainAttributes();
            Assert.assertEquals((Object)"jakarta.decorator;version=\"2.0\";uses:=\"jakarta.enterprise.inject\",jakarta.enterprise.context;version=\"2.0\";uses:=\"jakarta.enterprise.util,jakarta.inject\"", (Object)attrs.getValue("Export-Package"));
            Assert.assertEquals((Object)"jakarta.el,jakarta.enterprise.context;version=\"[2.0,3)\"", (Object)attrs.getValue("Import-Package"));
            Assert.assertEquals((Object)"osgi.contract;osgi.contract=JavaCDI;uses:=\"jakarta.enterprise.context,jakarta.enterprise.context.spi,jakarta.enterprise.context.control,jakarta.enterprise.util,jakarta.enterprise.inject,jakarta.enterprise.inject.spi,jakarta.enterprise.inject.spi.configurator,jakarta.enterprise.inject.literal,jakarta.enterprise.inject.se,jakarta.enterprise.event,jakarta.decorator\";version:List<Version>=\"2.0,1.2,1.1,1.0\"", (Object)attrs.getValue("Provide-Capability"));
            Assert.assertEquals((Object)"osgi.serviceloader;filter:=\"(osgi.serviceloader=jakarta.enterprise.inject.se.SeContainerInitializer)\";cardinality:=multiple,osgi.serviceloader;filter:=\"(osgi.serviceloader=jakarta.enterprise.inject.spi.CDIProvider)\";cardinality:=multiple,osgi.extender;filter:=\"(osgi.extender=osgi.serviceloader.processor)\",osgi.contract;osgi.contract=JavaEL;filter:=\"(&(osgi.contract=JavaEL)(version=2.2.0))\",osgi.contract;osgi.contract=JavaInterceptor;filter:=\"(&(osgi.contract=JavaInterceptor)(version=1.2.0))\",osgi.contract;osgi.contract=JavaInject;filter:=\"(&(osgi.contract=JavaInject)(version=1.0.0))\",osgi.ee;filter:=\"(&(osgi.ee=JavaSE)(version=1.8))\"", (Object)attrs.getValue("Require-Capability"));
        }
    }

    @Test
    public void rewriteAdditionalAttributes() throws Exception {
        Manifest manifest = new Manifest();
        Attributes attributes = manifest.getMainAttributes();
        attributes.put(Attributes.Name.MANIFEST_VERSION, "1.0");
        attributes.putValue("description-custom", "This jar uses javax packages");
        List<SimpleRelocator> relocators = Collections.singletonList(new SimpleRelocator("javax", "jakarta", Collections.emptyList(), Collections.emptyList()));
        this.transformer.setAdditionalAttributes(Arrays.asList("description-custom", "attribute-unknown"));
        ByteArrayOutputStream out = this.transform(manifest, relocators);
        try (JarInputStream jis = new JarInputStream(new ByteArrayInputStream(out.toByteArray()));){
            Attributes attrs = jis.getManifest().getMainAttributes();
            Assert.assertEquals((Object)"This jar uses jakarta packages", (Object)attrs.getValue("description-custom"));
        }
    }

    private ByteArrayOutputStream transform(Manifest manifest, List<Relocator> relocators) throws IOException {
        ByteArrayOutputStream mboas;
        try (ByteArrayOutputStream mos = mboas = new ByteArrayOutputStream();){
            manifest.write(mos);
        }
        this.transformer.processResource("META-INF/MANIFEST.MF", (InputStream)new ByteArrayInputStream(mboas.toByteArray()), relocators, 0L);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try (JarOutputStream jarOutputStream = new JarOutputStream(out);){
            this.transformer.modifyOutputStream(jarOutputStream);
        }
        return out;
    }
}

