/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.shade.resource;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;
import org.apache.commons.io.IOUtils;
import org.apache.maven.plugins.shade.relocation.Relocator;
import org.apache.maven.plugins.shade.relocation.SimpleRelocator;
import org.apache.maven.plugins.shade.resource.ServicesResourceTransformer;
import org.junit.Assert;
import org.junit.Test;

public class ServiceResourceTransformerTest {
    private List<Relocator> relocators = new ArrayList<Relocator>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void relocatedClasses() throws Exception {
        SimpleRelocator relocator = new SimpleRelocator("org.foo", "borg.foo", null, Arrays.asList("org.foo.exclude.*"));
        this.relocators.add((Relocator)relocator);
        String content = "org.foo.Service\norg.foo.exclude.OtherService\n";
        byte[] contentBytes = content.getBytes(StandardCharsets.UTF_8);
        ByteArrayInputStream contentStream = new ByteArrayInputStream(contentBytes);
        String contentResource = "META-INF/services/org.foo.something.another";
        String contentResourceShaded = "META-INF/services/borg.foo.something.another";
        ServicesResourceTransformer xformer = new ServicesResourceTransformer();
        xformer.processResource(contentResource, (InputStream)contentStream, this.relocators, 0L);
        ((InputStream)contentStream).close();
        File tempJar = File.createTempFile("shade.", ".jar");
        tempJar.deleteOnExit();
        FileOutputStream fos = new FileOutputStream(tempJar);
        try (JarOutputStream jos = new JarOutputStream(fos);){
            xformer.modifyOutputStream(jos);
            jos.close();
            JarFile jarFile = new JarFile(tempJar);
            JarEntry jarEntry = jarFile.getJarEntry(contentResourceShaded);
            Assert.assertNotNull((Object)jarEntry);
            try (InputStream entryStream = jarFile.getInputStream(jarEntry);){
                String xformedContent = IOUtils.toString((InputStream)entryStream, (String)"utf-8");
                Assert.assertEquals((Object)("borg.foo.Service" + System.getProperty("line.separator") + "org.foo.exclude.OtherService" + System.getProperty("line.separator")), (Object)xformedContent);
            }
            finally {
                jarFile.close();
            }
        }
        finally {
            tempJar.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void concatanationAppliedMultipleTimes() throws Exception {
        SimpleRelocator relocator = new SimpleRelocator("org.eclipse", "org.eclipse1234", null, null);
        this.relocators.add((Relocator)relocator);
        String content = "org.eclipse.osgi.launch.EquinoxFactory\n";
        byte[] contentBytes = content.getBytes("UTF-8");
        ByteArrayInputStream contentStream = new ByteArrayInputStream(contentBytes);
        String contentResource = "META-INF/services/org.osgi.framework.launch.FrameworkFactory";
        ServicesResourceTransformer xformer = new ServicesResourceTransformer();
        xformer.processResource(contentResource, (InputStream)contentStream, this.relocators, 0L);
        ((InputStream)contentStream).close();
        File tempJar = File.createTempFile("shade.", ".jar");
        tempJar.deleteOnExit();
        FileOutputStream fos = new FileOutputStream(tempJar);
        try (JarOutputStream jos = new JarOutputStream(fos);){
            xformer.modifyOutputStream(jos);
            jos.close();
            JarFile jarFile = new JarFile(tempJar);
            JarEntry jarEntry = jarFile.getJarEntry(contentResource);
            Assert.assertNotNull((Object)jarEntry);
            try (InputStream entryStream = jarFile.getInputStream(jarEntry);){
                String xformedContent = IOUtils.toString((InputStream)entryStream, (String)"utf-8");
                Assert.assertEquals((Object)("org.eclipse1234.osgi.launch.EquinoxFactory" + System.getProperty("line.separator")), (Object)xformedContent);
            }
            finally {
                jarFile.close();
            }
        }
        finally {
            tempJar.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void concatenation() throws Exception {
        SimpleRelocator relocator = new SimpleRelocator("org.foo", "borg.foo", null, null);
        this.relocators.add((Relocator)relocator);
        String content = "org.foo.Service\n";
        byte[] contentBytes = content.getBytes(StandardCharsets.UTF_8);
        ByteArrayInputStream contentStream = new ByteArrayInputStream(contentBytes);
        String contentResource = "META-INF/services/org.something.another";
        ServicesResourceTransformer xformer = new ServicesResourceTransformer();
        xformer.processResource(contentResource, (InputStream)contentStream, this.relocators, 0L);
        ((InputStream)contentStream).close();
        content = "org.blah.Service\n";
        contentBytes = content.getBytes(StandardCharsets.UTF_8);
        contentStream = new ByteArrayInputStream(contentBytes);
        contentResource = "META-INF/services/org.something.another";
        xformer.processResource(contentResource, (InputStream)contentStream, this.relocators, 0L);
        ((InputStream)contentStream).close();
        File tempJar = File.createTempFile("shade.", ".jar");
        tempJar.deleteOnExit();
        FileOutputStream fos = new FileOutputStream(tempJar);
        try (JarOutputStream jos = new JarOutputStream(fos);){
            xformer.modifyOutputStream(jos);
            jos.close();
            JarFile jarFile = new JarFile(tempJar);
            JarEntry jarEntry = jarFile.getJarEntry(contentResource);
            Assert.assertNotNull((Object)jarEntry);
            try (InputStream entryStream = jarFile.getInputStream(jarEntry);){
                String xformedContent = IOUtils.toString((InputStream)entryStream, (String)"utf-8");
                String[] classes = xformedContent.split("\r?\n");
                boolean h1 = false;
                boolean h2 = false;
                for (String name : classes) {
                    if ("org.blah.Service".equals(name)) {
                        h1 = true;
                        continue;
                    }
                    if (!"borg.foo.Service".equals(name)) continue;
                    h2 = true;
                }
                Assert.assertTrue((h1 && h2 ? 1 : 0) != 0);
            }
            finally {
                jarFile.close();
            }
        }
        finally {
            tempJar.delete();
        }
    }
}

