/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.shade.relocation;

import java.util.Arrays;
import java.util.Collections;
import org.apache.maven.plugins.shade.relocation.SimpleRelocator;
import org.junit.Assert;
import org.junit.Test;

public class SimpleRelocatorTest {
    @Test
    public void testCanRelocatePath() {
        SimpleRelocator relocator = new SimpleRelocator("org.foo", null, null, null);
        Assert.assertTrue((boolean)relocator.canRelocatePath("org/foo/Class"));
        Assert.assertTrue((boolean)relocator.canRelocatePath("org/foo/Class.class"));
        Assert.assertTrue((boolean)relocator.canRelocatePath("org/foo/bar/Class"));
        Assert.assertTrue((boolean)relocator.canRelocatePath("org/foo/bar/Class.class"));
        Assert.assertFalse((boolean)relocator.canRelocatePath("com/foo/bar/Class"));
        Assert.assertFalse((boolean)relocator.canRelocatePath("com/foo/bar/Class.class"));
        Assert.assertFalse((boolean)relocator.canRelocatePath("org/Foo/Class"));
        Assert.assertFalse((boolean)relocator.canRelocatePath("org/Foo/Class.class"));
        relocator = new SimpleRelocator("org.foo", null, null, Arrays.asList("org.foo.Excluded", "org.foo.public.*", "org.foo.Public*Stuff"));
        Assert.assertTrue((boolean)relocator.canRelocatePath("org/foo/Class"));
        Assert.assertTrue((boolean)relocator.canRelocatePath("org/foo/Class.class"));
        Assert.assertTrue((boolean)relocator.canRelocatePath("org/foo/excluded"));
        Assert.assertFalse((boolean)relocator.canRelocatePath("org/foo/Excluded"));
        Assert.assertFalse((boolean)relocator.canRelocatePath("org/foo/Excluded.class"));
        Assert.assertFalse((boolean)relocator.canRelocatePath("org/foo/public"));
        Assert.assertFalse((boolean)relocator.canRelocatePath("org/foo/public/Class"));
        Assert.assertFalse((boolean)relocator.canRelocatePath("org/foo/public/Class.class"));
        Assert.assertTrue((boolean)relocator.canRelocatePath("org/foo/publicRELOC/Class"));
        Assert.assertTrue((boolean)relocator.canRelocatePath("org/foo/PrivateStuff"));
        Assert.assertTrue((boolean)relocator.canRelocatePath("org/foo/PrivateStuff.class"));
        Assert.assertFalse((boolean)relocator.canRelocatePath("org/foo/PublicStuff"));
        Assert.assertFalse((boolean)relocator.canRelocatePath("org/foo/PublicStuff.class"));
        Assert.assertFalse((boolean)relocator.canRelocatePath("org/foo/PublicUtilStuff"));
        Assert.assertFalse((boolean)relocator.canRelocatePath("org/foo/PublicUtilStuff.class"));
    }

    @Test
    public void testCanRelocateClass() {
        SimpleRelocator relocator = new SimpleRelocator("org.foo", null, null, null);
        Assert.assertTrue((boolean)relocator.canRelocateClass("org.foo.Class"));
        Assert.assertTrue((boolean)relocator.canRelocateClass("org.foo.bar.Class"));
        Assert.assertFalse((boolean)relocator.canRelocateClass("com.foo.bar.Class"));
        Assert.assertFalse((boolean)relocator.canRelocateClass("org.Foo.Class"));
        relocator = new SimpleRelocator("org.foo", null, null, Arrays.asList("org.foo.Excluded", "org.foo.public.*", "org.foo.Public*Stuff"));
        Assert.assertTrue((boolean)relocator.canRelocateClass("org.foo.Class"));
        Assert.assertTrue((boolean)relocator.canRelocateClass("org.foo.excluded"));
        Assert.assertFalse((boolean)relocator.canRelocateClass("org.foo.Excluded"));
        Assert.assertFalse((boolean)relocator.canRelocateClass("org.foo.public"));
        Assert.assertFalse((boolean)relocator.canRelocateClass("org.foo.public.Class"));
        Assert.assertTrue((boolean)relocator.canRelocateClass("org.foo.publicRELOC.Class"));
        Assert.assertTrue((boolean)relocator.canRelocateClass("org.foo.PrivateStuff"));
        Assert.assertFalse((boolean)relocator.canRelocateClass("org.foo.PublicStuff"));
        Assert.assertFalse((boolean)relocator.canRelocateClass("org.foo.PublicUtilStuff"));
    }

    @Test
    public void testCanRelocateRawString() {
        SimpleRelocator relocator = new SimpleRelocator("org/foo", null, null, null, true);
        Assert.assertTrue((boolean)relocator.canRelocatePath("(I)org/foo/bar/Class;"));
        relocator = new SimpleRelocator("^META-INF/org.foo.xml$", null, null, null, true);
        Assert.assertTrue((boolean)relocator.canRelocatePath("META-INF/org.foo.xml"));
    }

    @Test
    public void testCanRelocateAbsClassPath() {
        SimpleRelocator relocator = new SimpleRelocator("org.apache.velocity", "org.apache.momentum", null, null);
        Assert.assertEquals((Object)"/org/apache/momentum/mass.properties", (Object)relocator.relocatePath("/org/apache/velocity/mass.properties"));
    }

    @Test
    public void testCanRelocateAbsClassPathWithExcludes() {
        SimpleRelocator relocator = new SimpleRelocator("org/apache/velocity", "org/apache/momentum", null, Arrays.asList("org/apache/velocity/excluded/*"));
        Assert.assertTrue((boolean)relocator.canRelocatePath("/org/apache/velocity/mass.properties"));
        Assert.assertTrue((boolean)relocator.canRelocatePath("org/apache/velocity/mass.properties"));
        Assert.assertFalse((boolean)relocator.canRelocatePath("/org/apache/velocity/excluded/mass.properties"));
        Assert.assertFalse((boolean)relocator.canRelocatePath("org/apache/velocity/excluded/mass.properties"));
    }

    @Test
    public void testCanRelocateAbsClassPathWithIncludes() {
        SimpleRelocator relocator = new SimpleRelocator("org/apache/velocity", "org/apache/momentum", Arrays.asList("org/apache/velocity/included/*"), null);
        Assert.assertFalse((boolean)relocator.canRelocatePath("/org/apache/velocity/mass.properties"));
        Assert.assertFalse((boolean)relocator.canRelocatePath("org/apache/velocity/mass.properties"));
        Assert.assertTrue((boolean)relocator.canRelocatePath("/org/apache/velocity/included/mass.properties"));
        Assert.assertTrue((boolean)relocator.canRelocatePath("org/apache/velocity/included/mass.properties"));
    }

    @Test
    public void testRelocatePath() {
        SimpleRelocator relocator = new SimpleRelocator("org.foo", null, null, null);
        Assert.assertEquals((Object)"hidden/org/foo/bar/Class.class", (Object)relocator.relocatePath("org/foo/bar/Class.class"));
        relocator = new SimpleRelocator("org.foo", "private.stuff", null, null);
        Assert.assertEquals((Object)"private/stuff/bar/Class.class", (Object)relocator.relocatePath("org/foo/bar/Class.class"));
    }

    @Test
    public void testRelocateClass() {
        SimpleRelocator relocator = new SimpleRelocator("org.foo", null, null, null);
        Assert.assertEquals((Object)"hidden.org.foo.bar.Class", (Object)relocator.relocateClass("org.foo.bar.Class"));
        relocator = new SimpleRelocator("org.foo", "private.stuff", null, null);
        Assert.assertEquals((Object)"private.stuff.bar.Class", (Object)relocator.relocateClass("org.foo.bar.Class"));
    }

    @Test
    public void testRelocateRawString() {
        SimpleRelocator relocator = new SimpleRelocator("Lorg/foo", "Lhidden/org/foo", null, null, true);
        Assert.assertEquals((Object)"(I)Lhidden/org/foo/bar/Class;", (Object)relocator.relocatePath("(I)Lorg/foo/bar/Class;"));
        relocator = new SimpleRelocator("^META-INF/org.foo.xml$", "META-INF/hidden.org.foo.xml", null, null, true);
        Assert.assertEquals((Object)"META-INF/hidden.org.foo.xml", (Object)relocator.relocatePath("META-INF/org.foo.xml"));
    }

    @Test
    public void testRelocateMavenFiles() {
        SimpleRelocator relocator = new SimpleRelocator("META-INF/maven", "META-INF/shade/maven", null, Collections.singletonList("META-INF/maven/com.foo.bar/artifactId/pom.*"));
        Assert.assertFalse((boolean)relocator.canRelocatePath("META-INF/maven/com.foo.bar/artifactId/pom.properties"));
        Assert.assertFalse((boolean)relocator.canRelocatePath("META-INF/maven/com.foo.bar/artifactId/pom.xml"));
        Assert.assertTrue((boolean)relocator.canRelocatePath("META-INF/maven/com/foo/bar/artifactId/pom.properties"));
        Assert.assertTrue((boolean)relocator.canRelocatePath("META-INF/maven/com/foo/bar/artifactId/pom.xml"));
        Assert.assertTrue((boolean)relocator.canRelocatePath("META-INF/maven/com-foo-bar/artifactId/pom.properties"));
        Assert.assertTrue((boolean)relocator.canRelocatePath("META-INF/maven/com-foo-bar/artifactId/pom.xml"));
    }
}

