/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.maven.shade;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.apache.maven.plugins.shade.mojo.PackageRelocation;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Before;
import org.junit.Test;
import org.mule.extensions.maven.shade.MuleArtifactDescriptorTransformer;

public class MuleArtifactDescriptorTransformerTestCase {
    private static final String HTTP_PATTERN = "org.mule.extension.http";
    private static final String HTTP_SHADE_PATTERN = "com.mulesoft.connectors.http.citizen";
    private static final String SOCKETS_PATTERN = "org.mule.extension.socket";
    private static final String SOCKETS_SHADE_PATTERN = "com.mulesoft.connectors.http.citizen.socket";
    private static final String COMMONS_PATTERN = "org.mule.db.commons";
    private static final String COMMONS_SHADE_PATTERN = "org.mule.db.commons.shaded";
    private static final String EXTENSIONS_PATTERN = "org.mule.extension.db";
    private static final String EXTENSIONS_SHADE_PATTERN = "org.mule";
    private static final String RESOURCE_PATH = "META-INF/mule-artifact/mule-artifact.json";
    private static final int RESOURCE_TIMESTAMP = 10;
    private MuleArtifactDescriptorTransformer transformer;

    @Before
    public void before() {
        this.transformer = new MuleArtifactDescriptorTransformer(this.getCitizenRelocations());
    }

    @Test
    public void shadeCitizenConnector() throws Exception {
        this.transformer.processResource(RESOURCE_PATH, this.getNonShadedMuleArtifact(), Collections.emptyList(), 10L);
        MatcherAssert.assertThat((Object)this.transformer.getShadedArtifactJson(), (Matcher)CoreMatchers.equalTo((Object)this.getShadedMuleArtifact()));
    }

    @Test
    public void doNotShadeRepeatableResource() throws Exception {
        this.shadeCitizenConnector();
        String shaded = this.transformer.getShadedArtifactJson();
        this.transformer.processResource(RESOURCE_PATH, (InputStream)new ByteArrayInputStream("random content".getBytes()), Collections.emptyList(), 10L);
        MatcherAssert.assertThat((Object)this.transformer.getShadedArtifactJson(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.sameInstance((Object)shaded)));
    }

    @Test
    public void doNotShadeWithoutTimestampSpecified() throws Exception {
        this.shadeCitizenConnector();
        String shaded = this.transformer.getShadedArtifactJson();
        this.transformer.processResource(RESOURCE_PATH, (InputStream)new ByteArrayInputStream("random content".getBytes()), Collections.emptyList());
        MatcherAssert.assertThat((Object)this.transformer.getShadedArtifactJson(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.sameInstance((Object)shaded)));
    }

    @Test
    public void doShadeOnBiggerTimestamp() throws Exception {
        this.shadeCitizenConnector();
        String newerArtifact = "random content";
        this.transformer.processResource(RESOURCE_PATH, (InputStream)new ByteArrayInputStream(newerArtifact.getBytes()), Collections.emptyList(), 11L);
        MatcherAssert.assertThat((Object)this.transformer.getShadedArtifactJson(), (Matcher)CoreMatchers.equalTo((Object)newerArtifact));
    }

    @Test
    public void idempotentShadingCitizenConnector() throws Exception {
        this.shadeCitizenConnector();
        String shaded = this.transformer.getShadedArtifactJson();
        this.transformer.processResource(RESOURCE_PATH, (InputStream)new ByteArrayInputStream(shaded.getBytes()), Collections.emptyList(), 11L);
        MatcherAssert.assertThat((Object)this.transformer.getShadedArtifactJson(), (Matcher)CoreMatchers.equalTo((Object)this.getShadedMuleArtifact()));
    }

    @Test
    public void shadeWhenPatternIsSubstringOfShadePattern() throws Exception {
        this.transformer = new MuleArtifactDescriptorTransformer(this.getDatabaseCommonsRelocation());
        this.transformer.processResource(RESOURCE_PATH, this.getNonShadedDatabaseArtifact(), Collections.emptyList(), 10L);
        String shadedArtifact = this.transformer.getShadedArtifactJson();
        MatcherAssert.assertThat((Object)shadedArtifact, (Matcher)CoreMatchers.equalTo((Object)this.getShadedCommonsDatabaseArtifact()));
    }

    @Test
    public void idempotentShadingWhenPatternIsSubstringOfShadePattern() throws Exception {
        this.shadeWhenPatternIsSubstringOfShadePattern();
        this.transformer.processResource(RESOURCE_PATH, (InputStream)new ByteArrayInputStream(this.transformer.getShadedArtifactJson().getBytes()), Collections.emptyList(), 11L);
        MatcherAssert.assertThat((Object)this.transformer.getShadedArtifactJson(), (Matcher)CoreMatchers.equalTo((Object)this.getShadedCommonsDatabaseArtifact()));
    }

    @Test
    public void shadeWhenShadePatternIsSubstringOfPattern() throws Exception {
        this.transformer = new MuleArtifactDescriptorTransformer(this.getDatabaseExtensionsRelocation());
        this.transformer.processResource(RESOURCE_PATH, this.getNonShadedDatabaseArtifact(), Collections.emptyList(), 10L);
        String shadedArtifact = this.transformer.getShadedArtifactJson();
        MatcherAssert.assertThat((Object)shadedArtifact, (Matcher)CoreMatchers.equalTo((Object)this.getShadedExtensionsDatabaseArtifact()));
    }

    @Test
    public void idempotentShadingWhenShadePatternIsSubstringOfPattern() throws Exception {
        this.shadeWhenShadePatternIsSubstringOfPattern();
        this.transformer.processResource(RESOURCE_PATH, (InputStream)new ByteArrayInputStream(this.transformer.getShadedArtifactJson().getBytes()), Collections.emptyList(), 11L);
        MatcherAssert.assertThat((Object)this.transformer.getShadedArtifactJson(), (Matcher)CoreMatchers.equalTo((Object)this.getShadedExtensionsDatabaseArtifact()));
    }

    @Test
    public void canTransformResource() {
        MatcherAssert.assertThat((Object)this.transformer.canTransformResource(RESOURCE_PATH), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)this.transformer.canTransformResource("random-resource"), (Matcher)CoreMatchers.is((Object)false));
    }

    @Test
    public void hasTransformedResource() {
        MatcherAssert.assertThat((Object)this.transformer.hasTransformedResource(), (Matcher)CoreMatchers.is((Object)true));
    }

    private PackageRelocation buildRelocation(String pattern, String shade) {
        PackageRelocation relocation = new PackageRelocation();
        relocation.setPattern(pattern);
        relocation.setShadedPattern(shade);
        return relocation;
    }

    private List<PackageRelocation> getCitizenRelocations() {
        return Arrays.asList(this.buildRelocation(HTTP_PATTERN, HTTP_SHADE_PATTERN), this.buildRelocation(SOCKETS_PATTERN, SOCKETS_SHADE_PATTERN));
    }

    private List<PackageRelocation> getDatabaseCommonsRelocation() {
        return Arrays.asList(this.buildRelocation(COMMONS_PATTERN, COMMONS_SHADE_PATTERN));
    }

    private List<PackageRelocation> getDatabaseExtensionsRelocation() {
        return Arrays.asList(this.buildRelocation(EXTENSIONS_PATTERN, EXTENSIONS_SHADE_PATTERN));
    }

    private InputStream getNonShadedMuleArtifact() {
        return this.getResourceAsStream("/artifact-descriptors/non-shaded-mule-artifact.json");
    }

    private InputStream getNonShadedDatabaseArtifact() {
        return this.getResourceAsStream("/artifact-descriptors/non-shaded-db-artifact.json");
    }

    private String getShadedMuleArtifact() throws IOException {
        return IOUtils.toString((InputStream)this.getResourceAsStream("/artifact-descriptors/shaded-mule-artifact.json"));
    }

    private String getShadedCommonsDatabaseArtifact() throws IOException {
        return IOUtils.toString((InputStream)this.getResourceAsStream("/artifact-descriptors/shaded-commons-db-artifact.json"));
    }

    private String getShadedExtensionsDatabaseArtifact() throws IOException {
        return IOUtils.toString((InputStream)this.getResourceAsStream("/artifact-descriptors/shaded-extensions-db-artifact.json"));
    }

    private InputStream getResourceAsStream(String path) {
        InputStream in = this.getClass().getResourceAsStream(path);
        MatcherAssert.assertThat((Object)in, (Matcher)CoreMatchers.notNullValue());
        return in;
    }
}

