/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.shade.filter;

import java.util.Collections;
import org.apache.maven.plugins.shade.filter.SimpleFilter;
import org.apache.maven.plugins.shade.mojo.ArchiveFilter;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class SimpleFilterTest {
    @Test
    public void testIsFiltered() {
        SimpleFilter filter = new SimpleFilter(null, null, null);
        Assert.assertFalse((boolean)filter.isFiltered("a.properties"));
        Assert.assertFalse((boolean)filter.isFiltered("org/Test.class"));
        filter = new SimpleFilter(null, Collections.emptySet(), Collections.emptySet());
        Assert.assertFalse((boolean)filter.isFiltered("a.properties"));
        Assert.assertFalse((boolean)filter.isFiltered("org/Test.class"));
        filter = new SimpleFilter(null, Collections.singleton("org/Test.class"), Collections.emptySet());
        Assert.assertTrue((boolean)filter.isFiltered("a.properties"));
        Assert.assertFalse((boolean)filter.isFiltered("org/Test.class"));
        Assert.assertTrue((boolean)filter.isFiltered("org/Test.properties"));
        filter = new SimpleFilter(null, Collections.emptySet(), Collections.singleton("org/Test.class"));
        Assert.assertFalse((boolean)filter.isFiltered("a.properties"));
        Assert.assertTrue((boolean)filter.isFiltered("org/Test.class"));
        Assert.assertFalse((boolean)filter.isFiltered("org/Test.properties"));
        filter = new SimpleFilter(null, Collections.singleton("**/a.properties"), Collections.emptySet());
        Assert.assertFalse((boolean)filter.isFiltered("a.properties"));
        Assert.assertFalse((boolean)filter.isFiltered("org/a.properties"));
        Assert.assertFalse((boolean)filter.isFiltered("org/maven/a.properties"));
        Assert.assertTrue((boolean)filter.isFiltered("org/maven/a.class"));
        filter = new SimpleFilter(null, Collections.emptySet(), Collections.singleton("org/*"));
        Assert.assertFalse((boolean)filter.isFiltered("Test.class"));
        Assert.assertTrue((boolean)filter.isFiltered("org/Test.class"));
        Assert.assertFalse((boolean)filter.isFiltered("org/apache/Test.class"));
        filter = new SimpleFilter(null, Collections.emptySet(), Collections.singleton("org/**"));
        Assert.assertFalse((boolean)filter.isFiltered("Test.class"));
        Assert.assertTrue((boolean)filter.isFiltered("org/Test.class"));
        Assert.assertTrue((boolean)filter.isFiltered("org/apache/Test.class"));
        filter = new SimpleFilter(null, Collections.emptySet(), Collections.singleton("org/"));
        Assert.assertFalse((boolean)filter.isFiltered("Test.class"));
        Assert.assertTrue((boolean)filter.isFiltered("org/Test.class"));
        Assert.assertTrue((boolean)filter.isFiltered("org/apache/Test.class"));
        ArchiveFilter archiveFilter = (ArchiveFilter)Mockito.mock(ArchiveFilter.class);
        Mockito.when((Object)archiveFilter.getIncludes()).thenReturn(Collections.singleton("specific include"));
        Mockito.when((Object)archiveFilter.getExcludes()).thenReturn(Collections.emptySet());
        Mockito.when((Object)archiveFilter.getExcludeDefaults()).thenReturn((Object)true);
        filter = new SimpleFilter(null, archiveFilter);
        Assert.assertFalse((boolean)filter.isFiltered("specific include"));
        Assert.assertTrue((boolean)filter.isFiltered("some other file matched by default include"));
        Mockito.when((Object)archiveFilter.getExcludeDefaults()).thenReturn((Object)false);
        filter = new SimpleFilter(null, archiveFilter);
        Assert.assertFalse((boolean)filter.isFiltered("specific include"));
        Assert.assertFalse((boolean)filter.isFiltered("some other file matched by default include"));
    }
}

