/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.shade.resource.properties;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import org.apache.maven.plugins.shade.resource.properties.PropertiesTransformer;
import org.apache.maven.plugins.shade.resource.properties.SortedProperties;
import org.apache.maven.plugins.shade.resource.properties.io.NoCloseOutputStream;
import org.apache.maven.plugins.shade.resource.properties.io.SkipPropertiesDateLineWriter;
import org.apache.maven.plugins.shade.resource.rule.TransformerTesterRule;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestRule;

public class PropertiesTransformerTest {
    @Rule
    public final TestRule tester = new TransformerTesterRule();

    @Test
    public void propertiesRewritingIsStable() throws IOException {
        SortedProperties properties = new SortedProperties();
        properties.setProperty("a", "1");
        properties.setProperty("b", "2");
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        SkipPropertiesDateLineWriter writer = new SkipPropertiesDateLineWriter((Writer)new OutputStreamWriter((OutputStream)new NoCloseOutputStream((OutputStream)os), StandardCharsets.ISO_8859_1));
        properties.store((Writer)writer, " Merged by maven-shade-plugin");
        writer.close();
        os.close();
        Assert.assertEquals((Object)"# Merged by maven-shade-plugin\na=1\nb=2\n", (Object)os.toString("UTF-8").replace(System.lineSeparator(), "\n"));
    }

    @Test
    public void canTransform() {
        PropertiesTransformer transformer = new PropertiesTransformer();
        transformer.setResource("foo/bar/my.properties");
        Assert.assertTrue((boolean)transformer.canTransformResource("foo/bar/my.properties"));
        Assert.assertFalse((boolean)transformer.canTransformResource("whatever"));
    }

    @Test
    @TransformerTesterRule.TransformerTest(transformer=PropertiesTransformer.class, configuration={@TransformerTesterRule.Property(name="resource", value="foo/bar/my.properties")}, visited={@TransformerTesterRule.Resource(path="foo/bar/my.properties", content="a=b"), @TransformerTesterRule.Resource(path="foo/bar/my.properties", content="c=d")}, expected={@TransformerTesterRule.Resource(path="foo/bar/my.properties", content="#.*\na=b\nc=d\n")})
    public void mergeWithoutOverlap() {
    }

    @Test
    @TransformerTesterRule.TransformerTest(transformer=PropertiesTransformer.class, configuration={@TransformerTesterRule.Property(name="resource", value="foo/bar/my.properties"), @TransformerTesterRule.Property(name="ordinalKey", value="priority")}, visited={@TransformerTesterRule.Resource(path="foo/bar/my.properties", content="a=d\npriority=3"), @TransformerTesterRule.Resource(path="foo/bar/my.properties", content="a=b\npriority=1"), @TransformerTesterRule.Resource(path="foo/bar/my.properties", content="a=c\npriority=2")}, expected={@TransformerTesterRule.Resource(path="foo/bar/my.properties", content="#.*\na=d\n")})
    public void mergeWithOverlap() {
    }

    @Test
    @TransformerTesterRule.TransformerTest(transformer=PropertiesTransformer.class, configuration={@TransformerTesterRule.Property(name="resource", value="foo/bar/my.properties"), @TransformerTesterRule.Property(name="alreadyMergedKey", value="complete")}, visited={@TransformerTesterRule.Resource(path="foo/bar/my.properties", content="a=b\ncomplete=true"), @TransformerTesterRule.Resource(path="foo/bar/my.properties", content="a=c\npriority=2")}, expected={@TransformerTesterRule.Resource(path="foo/bar/my.properties", content="#.*\na=b\n")})
    public void mergeWithAlreadyMerged() {
    }

    @Test
    @TransformerTesterRule.TransformerTest(transformer=PropertiesTransformer.class, configuration={@TransformerTesterRule.Property(name="resource", value="foo/bar/my.properties"), @TransformerTesterRule.Property(name="alreadyMergedKey", value="complete")}, visited={@TransformerTesterRule.Resource(path="foo/bar/my.properties", content="a=b\ncomplete=true"), @TransformerTesterRule.Resource(path="foo/bar/my.properties", content="a=c\ncomplete=true")}, expected={}, expectedException=IllegalStateException.class)
    public void alreadyMergeConflict() {
    }
}

