/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.shade.mojo;

import java.util.Collection;
import java.util.Collections;
import org.apache.maven.plugins.shade.mojo.ArtifactId;
import org.apache.maven.plugins.shade.mojo.ArtifactSelector;
import org.junit.Assert;
import org.junit.Test;

public class ArtifactSelectorTest {
    private ArtifactSelector newSelector(Collection<String> includes, Collection<String> excludes, String groupPrefix) {
        return new ArtifactSelector(includes, excludes, groupPrefix);
    }

    @Test
    public void testIsSelected() {
        ArtifactSelector selector = this.newSelector(null, null, null);
        Assert.assertTrue((boolean)selector.isSelected(new ArtifactId("gid", "aid", "type", "cls")));
        selector = this.newSelector(null, null, "");
        Assert.assertTrue((boolean)selector.isSelected(new ArtifactId("gid", "aid", "type", "cls")));
        selector = this.newSelector(null, null, "gid");
        Assert.assertTrue((boolean)selector.isSelected(new ArtifactId("gid", "aid", "type", "cls")));
        Assert.assertTrue((boolean)selector.isSelected(new ArtifactId("gid.test", "aid", "type", "cls")));
        Assert.assertFalse((boolean)selector.isSelected(new ArtifactId("id", "aid", "type", "cls")));
        selector = this.newSelector(Collections.emptySet(), Collections.emptySet(), null);
        Assert.assertTrue((boolean)selector.isSelected(new ArtifactId("gid", "aid", "type", "cls")));
        selector = this.newSelector(Collections.singleton("gid:aid"), Collections.emptySet(), null);
        Assert.assertTrue((boolean)selector.isSelected(new ArtifactId("gid", "aid", "type", "cls")));
        Assert.assertFalse((boolean)selector.isSelected(new ArtifactId("gid", "id", "type", "cls")));
        selector = this.newSelector(Collections.emptySet(), Collections.singleton("gid:aid"), null);
        Assert.assertFalse((boolean)selector.isSelected(new ArtifactId("gid", "aid", "type", "cls")));
        Assert.assertTrue((boolean)selector.isSelected(new ArtifactId("gid", "id", "type", "cls")));
        selector = this.newSelector(Collections.singleton("gid:*"), Collections.singleton("*:aid"), null);
        Assert.assertTrue((boolean)selector.isSelected(new ArtifactId("gid", "id", "type", "cls")));
        Assert.assertFalse((boolean)selector.isSelected(new ArtifactId("gid", "aid", "type", "cls")));
        Assert.assertFalse((boolean)selector.isSelected(new ArtifactId("gid.test", "id", "type", "cls")));
    }
}

