/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.plugin.maven;

import java.io.File;

import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;

/**
 * Base Mule Application Mojo
 */
public abstract class AbstractMuleMojo extends AbstractMojo {

  /**
   * Directory containing the generated Mule extension.
   */
  @Parameter(required = true, defaultValue = "${project.build.directory}")
  protected File outputDirectory;

  /**
   * Name of the generated Mule extension.
   */
  @Parameter(required = true, alias = "appName", defaultValue = "${project.build.finalName}")
  protected String finalName;

  /**
   * Directory containing the app resources.
   */
  @Parameter(required = true, defaultValue = "${project.build.directory}/src/main/app")
  protected File appDirectory;

  /**
   * The Maven project.
   */
  @Parameter(defaultValue = "${project}", readonly = true)
  public MavenProject project;


  protected File getMuleArtifactFile() {
    // TODO(fernandezlautaro): MULE-11383 all artifacts must be .jar files
    return new File(this.outputDirectory, this.finalName + ".zip");
  }
}

