/*
 * Decompiled with CFR 0.152.
 */
package org.mule.plugin.maven;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.project.MavenProject;
import org.mule.plugin.maven.Exclusion;
import org.mule.plugin.maven.Inclusion;

public class ArtifactFilter {
    private final Set<Artifact> projectArtifacts;
    private final List<Exclusion> excludes;
    private final List<Inclusion> includes;

    public ArtifactFilter(MavenProject project, List<Inclusion> inclusions, List<Exclusion> exclusions) {
        this.projectArtifacts = Collections.unmodifiableSet(project.getArtifacts());
        this.includes = inclusions;
        this.excludes = exclusions;
    }

    public Set<Artifact> getArtifactsToArchive() {
        Set<Artifact> filteredArtifacts = this.keepOnlyArtifactsWithCompileOrRuntimeScope();
        filteredArtifacts = this.applyAllExcludes(filteredArtifacts);
        return this.applyAllIncludes(filteredArtifacts);
    }

    private Set<Artifact> keepOnlyArtifactsWithCompileOrRuntimeScope() {
        HashSet<Artifact> filteredArtifacts = new HashSet<Artifact>();
        for (Artifact artifact : this.projectArtifacts) {
            String scope = artifact.getScope();
            if (!"compile".equals(scope) && !"runtime".equals(scope)) continue;
            filteredArtifacts.add(artifact);
        }
        return filteredArtifacts;
    }

    private Set<Artifact> applyAllExcludes(Set<Artifact> artifacts) {
        if (this.excludes != null) {
            for (Exclusion exclude : this.excludes) {
                artifacts = this.applyExclude(exclude, artifacts);
            }
        }
        return artifacts;
    }

    private Set<Artifact> applyExclude(Exclusion exclude, Set<Artifact> artifacts) {
        String filter = exclude.asFilter();
        HashSet<Artifact> filteredArtifacts = new HashSet<Artifact>();
        for (Artifact artifact : artifacts) {
            if (this.dependencyTrailContains(artifact, filter)) continue;
            filteredArtifacts.add(artifact);
        }
        return filteredArtifacts;
    }

    private boolean dependencyTrailContains(Artifact artifact, String filter) {
        List dependencyTrail = artifact.getDependencyTrail();
        for (Object trailElement : dependencyTrail) {
            if (!trailElement.toString().startsWith(filter)) continue;
            return true;
        }
        return false;
    }

    private Set<Artifact> applyAllIncludes(Set<Artifact> filteredArtifacts) {
        if (this.includes != null) {
            for (Inclusion inc : this.includes) {
                this.applyInclude(inc, filteredArtifacts);
            }
        }
        return filteredArtifacts;
    }

    private void applyInclude(Inclusion inclusion, Set<Artifact> filteredArtifacts) {
        String filter = inclusion.asFilter() + ":";
        for (Artifact artifact : this.projectArtifacts) {
            if (!this.dependencyTrailContains(artifact, filter) || artifact.isOptional()) continue;
            filteredArtifacts.add(artifact);
        }
    }
}

