/*
 * Decompiled with CFR 0.152.
 */
package org.mule.plugin.maven;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.model.Dependency;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProjectHelper;
import org.codehaus.plexus.archiver.ArchiverException;
import org.mule.plugin.maven.AbstractMuleMojo;
import org.mule.plugin.maven.ArtifactFilter;
import org.mule.plugin.maven.Exclusion;
import org.mule.plugin.maven.Inclusion;
import org.mule.plugin.maven.ModuleArchiver;
import org.mule.runtime.api.meta.MuleVersion;

public abstract class AbstractPackagePluginMojo
extends AbstractMuleMojo {
    public static final String MULE_PLUGIN_CLASSIFIER = "mule-plugin";
    static final String PLUGIN_PROPERTIES_FILE_NAME = "plugin.properties";
    private static final String BUNDLE_DESCRIPTOR_SEPARATOR = ":";
    private static final String CLASSES = "classes";
    private static final String CE_RUNTIME_GROUP_ID = "org.mule.runtime";
    private static final String EE_RUNTIME_GROUP_ID = "com.mulesoft.mule.runtime";
    private static final List<String> forbiddenScopesRuntimeDependencies = Arrays.asList("compile", "runtime", "system");
    private static final String RESERVED_DESTINATION_CLASSES = "";
    @Component
    private MavenProjectHelper projectHelper;
    @Parameter
    private List<Exclusion> exclusions;
    @Parameter
    private List<Inclusion> inclusions;

    protected abstract void doAddArtifactProperties(File var1) throws MojoFailureException;

    public final void execute() throws MojoExecutionException, MojoFailureException {
        this.initialize();
        this.validateVersion();
        this.validateDependencies();
        this.doExecute();
        File artifactFile = this.getMuleArtifactFile();
        try {
            this.createMulePlugin(artifactFile);
        }
        catch (ArchiverException e) {
            throw new MojoExecutionException("Exception creating the Mule Artifact", (Exception)((Object)e));
        }
        this.projectHelper.attachArtifact(this.project, "jar", this.getArtifactClassifier(), artifactFile);
    }

    private void validateVersion() throws MojoFailureException, MojoExecutionException {
        MuleVersion artifactVersion;
        if (this.project.getVersion() == null) {
            throw new MojoFailureException(String.format("No version specified in the project for artifact %s", this.project.getName()));
        }
        try {
            artifactVersion = new MuleVersion(this.project.getVersion());
        }
        catch (Exception e) {
            throw new MojoExecutionException(e.getMessage(), e);
        }
        if (artifactVersion.getRevision() == -1) {
            throw new MojoFailureException(String.format("Artifact %s version %s must contain a revision number. The version format must be x.y.z and the z part is missing", this.project.getName(), artifactVersion));
        }
    }

    private void validateDependencies() throws MojoFailureException {
        List forbiddenRuntimeDependencies = this.project.getDependencies().stream().filter(dependency -> forbiddenScopesRuntimeDependencies.contains(dependency.getScope())).filter(dependency -> dependency.getGroupId().startsWith(CE_RUNTIME_GROUP_ID) || dependency.getGroupId().startsWith(EE_RUNTIME_GROUP_ID)).map(Dependency::toString).collect(Collectors.toList());
        if (!forbiddenRuntimeDependencies.isEmpty()) {
            throw new MojoFailureException(String.format("There are [%d] runtime dependencies (groupId matches either [%s] or [%s]) which <scope> must be [%s], but found [%s]. Full list:\n %s", forbiddenRuntimeDependencies.size(), CE_RUNTIME_GROUP_ID, EE_RUNTIME_GROUP_ID, "provided", String.join((CharSequence)", ", forbiddenScopesRuntimeDependencies), String.join((CharSequence)",\n", forbiddenRuntimeDependencies)));
        }
    }

    protected String getArtifactClassifier() {
        return RESERVED_DESTINATION_CLASSES;
    }

    protected void createMulePlugin(File plugin) throws MojoExecutionException, MojoFailureException, ArchiverException {
        ModuleArchiver archiver = new ModuleArchiver();
        this.addToArchiver(archiver);
        archiver.setDestFile(plugin);
        try {
            plugin.delete();
            archiver.createArchive();
        }
        catch (IOException e) {
            this.getLog().error((CharSequence)"Cannot create archive", (Throwable)e);
        }
    }

    protected void addToArchiver(ModuleArchiver archiver) throws MojoFailureException {
        this.addDependencies(archiver);
        this.addArtifactProperties(archiver);
        this.addPOMFile(archiver);
    }

    protected void addPOMFile(ModuleArchiver archiver) {
        archiver.addFile(this.project.getFile(), Paths.get("META-INF", "maven", this.project.getGroupId(), this.project.getArtifactId(), "pom.xml").toString());
    }

    protected void addArtifactProperties(ModuleArchiver moduleArchiver) throws MojoFailureException {
        File pluginPropertiesFile = new File(this.outputDirectory, CLASSES + File.separator + PLUGIN_PROPERTIES_FILE_NAME);
        if (pluginPropertiesFile.exists()) {
            this.doAddArtifactProperties(pluginPropertiesFile);
            moduleArchiver.add(pluginPropertiesFile);
        }
    }

    protected void addDependencies(ModuleArchiver archiver) throws ArchiverException {
        for (Artifact artifact : this.getArtifactsToArchive()) {
            this.getLog().info((CharSequence)String.format("Adding <%1s> as a lib", artifact.getId()));
            archiver.addLib(artifact.getFile());
        }
    }

    private Set<Artifact> getArtifactsToArchive() {
        ArtifactFilter filter = new ArtifactFilter(this.project, this.inclusions, this.exclusions);
        return filter.getArtifactsToArchive();
    }

    protected Set<String> getPluginDependencies() {
        List allDependencies = this.project.getDependencies();
        return allDependencies.stream().filter(d -> d.getClassifier() != null && d.getClassifier().equals(MULE_PLUGIN_CLASSIFIER)).map(d -> d.getGroupId() + BUNDLE_DESCRIPTOR_SEPARATOR + d.getArtifactId() + BUNDLE_DESCRIPTOR_SEPARATOR + d.getVersion()).collect(Collectors.toSet());
    }

    protected void initialize() throws MojoFailureException, MojoExecutionException {
    }

    protected void doExecute() throws MojoFailureException, MojoExecutionException {
    }

    protected void walkWhileCopyingFolder(final ModuleArchiver archiver, final String destination, final Path startPath) {
        try {
            Files.walkFileTree(startPath, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path currentPath, BasicFileAttributes attrs) throws IOException {
                    String dest = destination + startPath.relativize(currentPath);
                    archiver.addFile(currentPath.toFile(), dest);
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        catch (IOException e) {
            throw new ArchiverException(String.format("Error copying folder [%s], from start [%s]", destination, startPath.toString()), (Throwable)e);
        }
    }

    protected void addClasses(ModuleArchiver archiver) {
        Path startPath = Paths.get(this.outputDirectory.getAbsolutePath(), CLASSES);
        this.walkWhileCopyingFolder(archiver, RESERVED_DESTINATION_CLASSES, startPath);
    }
}

