/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.plugin.maven;

import static java.io.File.separator;

import java.io.File;

import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;

/**
 * Base Mule Application Mojo
 */
public abstract class AbstractMuleMojo extends AbstractMojo {

  private static final String REPOSITORY_FOLDER = "repository";
  protected static final String META_INF = "META-INF";

  public static final String MULE_ARTIFACT_TYPE = "jar";

  public static final String MULE_ARTIFACT = "mule-artifact";

  public static final String MULE_ARTIFACT_JSON = MULE_ARTIFACT + ".json";
  /**
   * Target folder for any files used at deployment time.
   */
  protected static final String RESERVED_FOLDER_MULE_ARTIFACT = META_INF + separator + MULE_ARTIFACT + separator;

  public static final String MULE_PLUGIN_JSON_JAR_DESTINATION = RESERVED_FOLDER_MULE_ARTIFACT + MULE_ARTIFACT_JSON;

  /**
   * Target folder for the internal and cloned repository within the plugin end package.
   */
  protected static final String RESERVED_DESTINATION_REPOSITORY = RESERVED_FOLDER_MULE_ARTIFACT + REPOSITORY_FOLDER + separator;

  /**
   * Directory containing the generated Mule extension.
   */
  @Parameter(required = true, defaultValue = "${project.build.directory}")
  protected File outputDirectory;

  /**
   * Name of the generated Mule extension.
   */
  @Parameter(required = true, alias = "appName", defaultValue = "${project.build.finalName}")
  protected String finalName;

  /**
   * Directory containing the app resources.
   */
  @Parameter(required = true, defaultValue = "${project.build.directory}/src/main/app")
  protected File appDirectory;

  /**
   * The Maven project.
   */
  @Parameter(defaultValue = "${project}", readonly = true, required = true)
  public MavenProject project;


  protected File getMuleArtifactFile() {
    return new File(this.outputDirectory, this.finalName + "." + MULE_ARTIFACT_TYPE);
  }
}

