/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.plugin.maven;

import java.io.File;

import org.codehaus.plexus.archiver.ArchiverException;
import org.codehaus.plexus.archiver.zip.ZipArchiver;

/**
 * Creates the structure and archive for a Mule Application
 */
public class ModuleArchiver extends ZipArchiver {

  public final static String LIB_PREFIX = "lib/";
  public final static String JAVA_VERSION_PREFIX = "java-versions/";
  public final static String ROOT_PREFIX = "";

  public void addJavaVersionLib(int javaVersion, final File file) throws ArchiverException {
    addFile(file, LIB_PREFIX + JAVA_VERSION_PREFIX + javaVersion + "/" + file.getName());
  }

  public void addLib(final File file) throws ArchiverException {
    addFile(file, LIB_PREFIX + file.getName());
  }

  public void add(final File file) throws ArchiverException {
    addFile(file, ROOT_PREFIX + file.getName());
  }
}
