/*
 * Decompiled with CFR 0.152.
 */
package org.mule.plugin.maven;

import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;

public class PluginProperties {
    public static final String ARTIFACT_EXPORT_CLASS_PACKAGES = "artifact.export.classPackages";
    public static final String ARTIFACT_EXPORT_RESOURCES = "artifact.export.resources";
    public static final String PLUGIN_DEPENDENCIES = "plugin.dependencies";
    public static final String PLUGIN_BUNDLE = "plugin.bundle";
    private static final String PROPERTIES_COMMENT = "Plugin Properties";
    private String exportedPackages;
    private String pluginDependencies;
    private String exportedResources;
    private String pluginBundle;

    public PluginProperties(List<String> exportedPackageNames, List<String> exportedResources, Set<String> pluginDependencies) {
        this.exportedPackages = StringUtils.join(exportedPackageNames, (String)",");
        this.exportedResources = StringUtils.join(exportedResources, (String)",");
        this.pluginDependencies = StringUtils.join(pluginDependencies, (String)",");
    }

    public PluginProperties(String exportedPackages, String exportedResources, String pluginDependencies, String pluginBundle) {
        this.exportedPackages = exportedPackages != null ? exportedPackages : "";
        this.exportedResources = exportedResources != null ? exportedResources : "";
        this.pluginDependencies = pluginDependencies != null ? pluginDependencies : "";
        this.pluginBundle = pluginBundle != null ? pluginBundle : "";
    }

    public void writeTo(OutputStream out) throws IOException {
        Properties properties = new Properties();
        this.doWriteProperties(properties);
        properties.store(out, PROPERTIES_COMMENT);
    }

    protected void doWriteProperties(Properties properties) {
        properties.setProperty(ARTIFACT_EXPORT_RESOURCES, this.exportedResources);
        properties.setProperty(ARTIFACT_EXPORT_CLASS_PACKAGES, this.exportedPackages);
        if (StringUtils.isNotBlank((CharSequence)this.pluginDependencies)) {
            properties.setProperty(PLUGIN_DEPENDENCIES, this.pluginDependencies);
        }
        if (StringUtils.isNotBlank((CharSequence)this.pluginBundle)) {
            properties.setProperty(PLUGIN_BUNDLE, this.pluginBundle);
        }
    }
}

